@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.EncodedTaskStepArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties of a encoded task step.
 * @property contextAccessToken The token (git PAT or SAS token of storage account blob) associated with the context for a step.
 * @property contextPath The URL(absolute or relative) of the source context for the task step.
 * @property encodedTaskContent Base64 encoded value of the template/definition file content.
 * @property encodedValuesContent Base64 encoded value of the parameters/values file content.
 * @property type The type of the step.
 * Expected value is 'EncodedTask'.
 * @property values The collection of overridable values that can be passed when running a task.
 */
public data class EncodedTaskStepArgs(
    public val contextAccessToken: Output<String>? = null,
    public val contextPath: Output<String>? = null,
    public val encodedTaskContent: Output<String>,
    public val encodedValuesContent: Output<String>? = null,
    public val type: Output<String>,
    public val values: Output<List<SetValueArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.EncodedTaskStepArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.EncodedTaskStepArgs =
        com.pulumi.azurenative.containerregistry.inputs.EncodedTaskStepArgs.builder()
            .contextAccessToken(contextAccessToken?.applyValue({ args0 -> args0 }))
            .contextPath(contextPath?.applyValue({ args0 -> args0 }))
            .encodedTaskContent(encodedTaskContent.applyValue({ args0 -> args0 }))
            .encodedValuesContent(encodedValuesContent?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .values(
                values?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EncodedTaskStepArgs].
 */
@PulumiTagMarker
public class EncodedTaskStepArgsBuilder internal constructor() {
    private var contextAccessToken: Output<String>? = null

    private var contextPath: Output<String>? = null

    private var encodedTaskContent: Output<String>? = null

    private var encodedValuesContent: Output<String>? = null

    private var type: Output<String>? = null

    private var values: Output<List<SetValueArgs>>? = null

    /**
     * @param value The token (git PAT or SAS token of storage account blob) associated with the context for a step.
     */
    @JvmName("hdjrevafjmteycfb")
    public suspend fun contextAccessToken(`value`: Output<String>) {
        this.contextAccessToken = value
    }

    /**
     * @param value The URL(absolute or relative) of the source context for the task step.
     */
    @JvmName("aaxlwlerrtfrscxl")
    public suspend fun contextPath(`value`: Output<String>) {
        this.contextPath = value
    }

    /**
     * @param value Base64 encoded value of the template/definition file content.
     */
    @JvmName("rabdrcjaasjcxrxs")
    public suspend fun encodedTaskContent(`value`: Output<String>) {
        this.encodedTaskContent = value
    }

    /**
     * @param value Base64 encoded value of the parameters/values file content.
     */
    @JvmName("deasvxtjnyfqcvno")
    public suspend fun encodedValuesContent(`value`: Output<String>) {
        this.encodedValuesContent = value
    }

    /**
     * @param value The type of the step.
     * Expected value is 'EncodedTask'.
     */
    @JvmName("hloblvscvbokoqio")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The collection of overridable values that can be passed when running a task.
     */
    @JvmName("wydbuevewecsrnjn")
    public suspend fun values(`value`: Output<List<SetValueArgs>>) {
        this.values = value
    }

    @JvmName("youxmhhlvgibbqeh")
    public suspend fun values(vararg values: Output<SetValueArgs>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values The collection of overridable values that can be passed when running a task.
     */
    @JvmName("rwvxkpsjuegueska")
    public suspend fun values(values: List<Output<SetValueArgs>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The token (git PAT or SAS token of storage account blob) associated with the context for a step.
     */
    @JvmName("baqqohflmcfeigiv")
    public suspend fun contextAccessToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contextAccessToken = mapped
    }

    /**
     * @param value The URL(absolute or relative) of the source context for the task step.
     */
    @JvmName("wygiwxbjnodwntqu")
    public suspend fun contextPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contextPath = mapped
    }

    /**
     * @param value Base64 encoded value of the template/definition file content.
     */
    @JvmName("ywravinvyjyrlyyi")
    public suspend fun encodedTaskContent(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encodedTaskContent = mapped
    }

    /**
     * @param value Base64 encoded value of the parameters/values file content.
     */
    @JvmName("tmlfemrssyhslpqi")
    public suspend fun encodedValuesContent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encodedValuesContent = mapped
    }

    /**
     * @param value The type of the step.
     * Expected value is 'EncodedTask'.
     */
    @JvmName("isyfusapwvcadxgg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The collection of overridable values that can be passed when running a task.
     */
    @JvmName("mmalmwekpbfpdhvh")
    public suspend fun values(`value`: List<SetValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param argument The collection of overridable values that can be passed when running a task.
     */
    @JvmName("cqkfxquqwdiucihf")
    public suspend fun values(argument: List<suspend SetValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SetValueArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param argument The collection of overridable values that can be passed when running a task.
     */
    @JvmName("bqwsdamxahpyvjvx")
    public suspend fun values(vararg argument: suspend SetValueArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SetValueArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param argument The collection of overridable values that can be passed when running a task.
     */
    @JvmName("sbjwivjtdvjorrob")
    public suspend fun values(argument: suspend SetValueArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SetValueArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param values The collection of overridable values that can be passed when running a task.
     */
    @JvmName("ahanbejygquassdv")
    public suspend fun values(vararg values: SetValueArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): EncodedTaskStepArgs = EncodedTaskStepArgs(
        contextAccessToken = contextAccessToken,
        contextPath = contextPath,
        encodedTaskContent = encodedTaskContent ?: throw PulumiNullFieldException("encodedTaskContent"),
        encodedValuesContent = encodedValuesContent,
        type = type ?: throw PulumiNullFieldException("type"),
        values = values,
    )
}
