@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.GetPipelineRunPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property pipelineRunName The name of the pipeline run.
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPipelineRunPlainArgs(
    public val pipelineRunName: String,
    public val registryName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.GetPipelineRunPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.GetPipelineRunPlainArgs =
        com.pulumi.azurenative.containerregistry.inputs.GetPipelineRunPlainArgs.builder()
            .pipelineRunName(pipelineRunName.let({ args0 -> args0 }))
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPipelineRunPlainArgs].
 */
@PulumiTagMarker
public class GetPipelineRunPlainArgsBuilder internal constructor() {
    private var pipelineRunName: String? = null

    private var registryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the pipeline run.
     */
    @JvmName("fcbhopvbaucucggx")
    public suspend fun pipelineRunName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.pipelineRunName = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("yhuxyywxijnlggcu")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("edfqdbkyumvnxwds")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPipelineRunPlainArgs = GetPipelineRunPlainArgs(
        pipelineRunName = pipelineRunName ?: throw PulumiNullFieldException("pipelineRunName"),
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
