@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.IdentityPropertiesArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.ResourceIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Managed identity for the resource.
 * @property principalId The principal ID of resource identity.
 * @property tenantId The tenant ID of resource.
 * @property type The identity type.
 * @property userAssignedIdentities The list of user identities associated with the resource. The user identity
 * dictionary key references will be ARM resource ids in the form:
 * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
 *     providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
 */
public data class IdentityPropertiesArgs(
    public val principalId: Output<String>? = null,
    public val tenantId: Output<String>? = null,
    public val type: Output<ResourceIdentityType>? = null,
    public val userAssignedIdentities: Output<Map<String, UserIdentityPropertiesArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.IdentityPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.IdentityPropertiesArgs =
        com.pulumi.azurenative.containerregistry.inputs.IdentityPropertiesArgs.builder()
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IdentityPropertiesArgs].
 */
@PulumiTagMarker
public class IdentityPropertiesArgsBuilder internal constructor() {
    private var principalId: Output<String>? = null

    private var tenantId: Output<String>? = null

    private var type: Output<ResourceIdentityType>? = null

    private var userAssignedIdentities: Output<Map<String, UserIdentityPropertiesArgs>>? = null

    /**
     * @param value The principal ID of resource identity.
     */
    @JvmName("skpjhiarrbjahncn")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value The tenant ID of resource.
     */
    @JvmName("whhfmiktuoyxjdrx")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The identity type.
     */
    @JvmName("wxjuwcyyrayrlqcf")
    public suspend fun type(`value`: Output<ResourceIdentityType>) {
        this.type = value
    }

    /**
     * @param value The list of user identities associated with the resource. The user identity
     * dictionary key references will be ARM resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
     *     providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("eifqauwytlodkqrc")
    public suspend
    fun userAssignedIdentities(`value`: Output<Map<String, UserIdentityPropertiesArgs>>) {
        this.userAssignedIdentities = value
    }

    /**
     * @param value The principal ID of resource identity.
     */
    @JvmName("gykixleqgpfuamwf")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value The tenant ID of resource.
     */
    @JvmName("voxhhjyyegheaylg")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value The identity type.
     */
    @JvmName("odalnaqkcstjcihl")
    public suspend fun type(`value`: ResourceIdentityType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The list of user identities associated with the resource. The user identity
     * dictionary key references will be ARM resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
     *     providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("phevvljqsxnewiro")
    public suspend fun userAssignedIdentities(`value`: Map<String, UserIdentityPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param argument The list of user identities associated with the resource. The user identity
     * dictionary key references will be ARM resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
     *     providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("wghtfhfkobvrvmux")
    public suspend fun userAssignedIdentities(
        vararg
        argument: Pair<String, suspend UserIdentityPropertiesArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                UserIdentityPropertiesArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The list of user identities associated with the resource. The user identity
     * dictionary key references will be ARM resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
     *     providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("qjtfdcggugeijhwf")
    public fun userAssignedIdentities(vararg values: Pair<String, UserIdentityPropertiesArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): IdentityPropertiesArgs = IdentityPropertiesArgs(
        principalId = principalId,
        tenantId = tenantId,
        type = type,
        userAssignedIdentities = userAssignedIdentities,
    )
}
