@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.PipelineRunRequestArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The request properties provided for a pipeline run.
 * @property artifacts List of source artifacts to be transferred by the pipeline.
 * Specify an image by repository ('hello-world'). This will use the 'latest' tag.
 * Specify an image by tag ('hello-world:latest').
 * Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
 * @property catalogDigest The digest of the tar used to transfer the artifacts.
 * @property pipelineResourceId The resource ID of the pipeline to run.
 * @property source The source properties of the pipeline run.
 * @property target The target properties of the pipeline run.
 */
public data class PipelineRunRequestArgs(
    public val artifacts: Output<List<String>>? = null,
    public val catalogDigest: Output<String>? = null,
    public val pipelineResourceId: Output<String>? = null,
    public val source: Output<PipelineRunSourcePropertiesArgs>? = null,
    public val target: Output<PipelineRunTargetPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.PipelineRunRequestArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.PipelineRunRequestArgs =
        com.pulumi.azurenative.containerregistry.inputs.PipelineRunRequestArgs.builder()
            .artifacts(artifacts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .catalogDigest(catalogDigest?.applyValue({ args0 -> args0 }))
            .pipelineResourceId(pipelineResourceId?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .target(target?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PipelineRunRequestArgs].
 */
@PulumiTagMarker
public class PipelineRunRequestArgsBuilder internal constructor() {
    private var artifacts: Output<List<String>>? = null

    private var catalogDigest: Output<String>? = null

    private var pipelineResourceId: Output<String>? = null

    private var source: Output<PipelineRunSourcePropertiesArgs>? = null

    private var target: Output<PipelineRunTargetPropertiesArgs>? = null

    /**
     * @param value List of source artifacts to be transferred by the pipeline.
     * Specify an image by repository ('hello-world'). This will use the 'latest' tag.
     * Specify an image by tag ('hello-world:latest').
     * Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
     */
    @JvmName("ievorljgravmniuw")
    public suspend fun artifacts(`value`: Output<List<String>>) {
        this.artifacts = value
    }

    @JvmName("dmybafmlxubnghka")
    public suspend fun artifacts(vararg values: Output<String>) {
        this.artifacts = Output.all(values.asList())
    }

    /**
     * @param values List of source artifacts to be transferred by the pipeline.
     * Specify an image by repository ('hello-world'). This will use the 'latest' tag.
     * Specify an image by tag ('hello-world:latest').
     * Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
     */
    @JvmName("haweljppmwxymfbt")
    public suspend fun artifacts(values: List<Output<String>>) {
        this.artifacts = Output.all(values)
    }

    /**
     * @param value The digest of the tar used to transfer the artifacts.
     */
    @JvmName("pvdfvuwwaftmhinb")
    public suspend fun catalogDigest(`value`: Output<String>) {
        this.catalogDigest = value
    }

    /**
     * @param value The resource ID of the pipeline to run.
     */
    @JvmName("hpkgraiuokpiftbj")
    public suspend fun pipelineResourceId(`value`: Output<String>) {
        this.pipelineResourceId = value
    }

    /**
     * @param value The source properties of the pipeline run.
     */
    @JvmName("rrdugbtuumkdabau")
    public suspend fun source(`value`: Output<PipelineRunSourcePropertiesArgs>) {
        this.source = value
    }

    /**
     * @param value The target properties of the pipeline run.
     */
    @JvmName("nfisstejxsavkwoc")
    public suspend fun target(`value`: Output<PipelineRunTargetPropertiesArgs>) {
        this.target = value
    }

    /**
     * @param value List of source artifacts to be transferred by the pipeline.
     * Specify an image by repository ('hello-world'). This will use the 'latest' tag.
     * Specify an image by tag ('hello-world:latest').
     * Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
     */
    @JvmName("bltqsufukyvnyoaw")
    public suspend fun artifacts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifacts = mapped
    }

    /**
     * @param values List of source artifacts to be transferred by the pipeline.
     * Specify an image by repository ('hello-world'). This will use the 'latest' tag.
     * Specify an image by tag ('hello-world:latest').
     * Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
     */
    @JvmName("mxrmwseiwqrwluxe")
    public suspend fun artifacts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.artifacts = mapped
    }

    /**
     * @param value The digest of the tar used to transfer the artifacts.
     */
    @JvmName("deqrvmfvhucbngsc")
    public suspend fun catalogDigest(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogDigest = mapped
    }

    /**
     * @param value The resource ID of the pipeline to run.
     */
    @JvmName("sdprcgqupoqnaepx")
    public suspend fun pipelineResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineResourceId = mapped
    }

    /**
     * @param value The source properties of the pipeline run.
     */
    @JvmName("koduqklustbyypgh")
    public suspend fun source(`value`: PipelineRunSourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument The source properties of the pipeline run.
     */
    @JvmName("porbfdgwiekkwvck")
    public suspend fun source(argument: suspend PipelineRunSourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineRunSourcePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    /**
     * @param value The target properties of the pipeline run.
     */
    @JvmName("hspeosegrmcxuwoq")
    public suspend fun target(`value`: PipelineRunTargetPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param argument The target properties of the pipeline run.
     */
    @JvmName("ufqjilkfgwawxcoi")
    public suspend fun target(argument: suspend PipelineRunTargetPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineRunTargetPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.target = mapped
    }

    internal fun build(): PipelineRunRequestArgs = PipelineRunRequestArgs(
        artifacts = artifacts,
        catalogDigest = catalogDigest,
        pipelineResourceId = pipelineResourceId,
        source = source,
        target = target,
    )
}
