@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.PipelineSourceTriggerPropertiesArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.TriggerStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property status The current status of the source trigger.
 */
public data class PipelineSourceTriggerPropertiesArgs(
    public val status: Output<Either<String, TriggerStatus>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.PipelineSourceTriggerPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerregistry.inputs.PipelineSourceTriggerPropertiesArgs =
        com.pulumi.azurenative.containerregistry.inputs.PipelineSourceTriggerPropertiesArgs.builder()
            .status(
                status.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PipelineSourceTriggerPropertiesArgs].
 */
@PulumiTagMarker
public class PipelineSourceTriggerPropertiesArgsBuilder internal constructor() {
    private var status: Output<Either<String, TriggerStatus>>? = null

    /**
     * @param value The current status of the source trigger.
     */
    @JvmName("rjhisupqfnfworlh")
    public suspend fun status(`value`: Output<Either<String, TriggerStatus>>) {
        this.status = value
    }

    /**
     * @param value The current status of the source trigger.
     */
    @JvmName("cpbncksmgiuyikvl")
    public suspend fun status(`value`: Either<String, TriggerStatus>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The current status of the source trigger.
     */
    @JvmName("aawgxkgdrjwjtjsl")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TriggerStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The current status of the source trigger.
     */
    @JvmName("giounvnjsgwcnnri")
    public fun status(`value`: TriggerStatus) {
        val toBeMapped = Either.ofRight<String, TriggerStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): PipelineSourceTriggerPropertiesArgs = PipelineSourceTriggerPropertiesArgs(
        status = status ?: throw PulumiNullFieldException("status"),
    )
}
