@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.PlatformPropertiesArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.Architecture
import com.pulumi.azurenative.containerregistry.kotlin.enums.OS
import com.pulumi.azurenative.containerregistry.kotlin.enums.Variant
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The platform properties against which the run has to happen.
 * @property architecture The OS architecture.
 * @property os The operating system type required for the run.
 * @property variant Variant of the CPU.
 */
public data class PlatformPropertiesArgs(
    public val architecture: Output<Either<String, Architecture>>? = null,
    public val os: Output<Either<String, OS>>,
    public val variant: Output<Either<String, Variant>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.PlatformPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.PlatformPropertiesArgs =
        com.pulumi.azurenative.containerregistry.inputs.PlatformPropertiesArgs.builder()
            .architecture(
                architecture?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .os(
                os.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .variant(
                variant?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PlatformPropertiesArgs].
 */
@PulumiTagMarker
public class PlatformPropertiesArgsBuilder internal constructor() {
    private var architecture: Output<Either<String, Architecture>>? = null

    private var os: Output<Either<String, OS>>? = null

    private var variant: Output<Either<String, Variant>>? = null

    /**
     * @param value The OS architecture.
     */
    @JvmName("tlkobcyhfmjdhsgw")
    public suspend fun architecture(`value`: Output<Either<String, Architecture>>) {
        this.architecture = value
    }

    /**
     * @param value The operating system type required for the run.
     */
    @JvmName("ripkycuynhnjnlcq")
    public suspend fun os(`value`: Output<Either<String, OS>>) {
        this.os = value
    }

    /**
     * @param value Variant of the CPU.
     */
    @JvmName("yhvqtktdhkbyvfoh")
    public suspend fun variant(`value`: Output<Either<String, Variant>>) {
        this.variant = value
    }

    /**
     * @param value The OS architecture.
     */
    @JvmName("tpruuumxgagwkqko")
    public suspend fun architecture(`value`: Either<String, Architecture>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.architecture = mapped
    }

    /**
     * @param value The OS architecture.
     */
    @JvmName("snfoubqsybmykcmx")
    public fun architecture(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Architecture>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.architecture = mapped
    }

    /**
     * @param value The OS architecture.
     */
    @JvmName("eujcdhwrmhwgdddy")
    public fun architecture(`value`: Architecture) {
        val toBeMapped = Either.ofRight<String, Architecture>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.architecture = mapped
    }

    /**
     * @param value The operating system type required for the run.
     */
    @JvmName("axuqfkpxplhlijwe")
    public suspend fun os(`value`: Either<String, OS>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.os = mapped
    }

    /**
     * @param value The operating system type required for the run.
     */
    @JvmName("neykkksflvtdiasp")
    public fun os(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OS>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.os = mapped
    }

    /**
     * @param value The operating system type required for the run.
     */
    @JvmName("pjtxbgdwvxqchgnb")
    public fun os(`value`: OS) {
        val toBeMapped = Either.ofRight<String, OS>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.os = mapped
    }

    /**
     * @param value Variant of the CPU.
     */
    @JvmName("awtwmskbjstuewya")
    public suspend fun variant(`value`: Either<String, Variant>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variant = mapped
    }

    /**
     * @param value Variant of the CPU.
     */
    @JvmName("umfnbfbyphhxadur")
    public fun variant(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Variant>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variant = mapped
    }

    /**
     * @param value Variant of the CPU.
     */
    @JvmName("pwmkrgljuyupupdy")
    public fun variant(`value`: Variant) {
        val toBeMapped = Either.ofRight<String, Variant>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variant = mapped
    }

    internal fun build(): PlatformPropertiesArgs = PlatformPropertiesArgs(
        architecture = architecture,
        os = os ?: throw PulumiNullFieldException("os"),
        variant = variant,
    )
}
