@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.PoliciesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The policies for a container registry.
 * @property exportPolicy The export policy for a container registry.
 * @property quarantinePolicy The quarantine policy for a container registry.
 * @property retentionPolicy The retention policy for a container registry.
 * @property trustPolicy The content trust policy for a container registry.
 */
public data class PoliciesArgs(
    public val exportPolicy: Output<ExportPolicyArgs>? = null,
    public val quarantinePolicy: Output<QuarantinePolicyArgs>? = null,
    public val retentionPolicy: Output<RetentionPolicyArgs>? = null,
    public val trustPolicy: Output<TrustPolicyArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.PoliciesArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.PoliciesArgs =
        com.pulumi.azurenative.containerregistry.inputs.PoliciesArgs.builder()
            .exportPolicy(exportPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .quarantinePolicy(quarantinePolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .retentionPolicy(retentionPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .trustPolicy(trustPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PoliciesArgs].
 */
@PulumiTagMarker
public class PoliciesArgsBuilder internal constructor() {
    private var exportPolicy: Output<ExportPolicyArgs>? = null

    private var quarantinePolicy: Output<QuarantinePolicyArgs>? = null

    private var retentionPolicy: Output<RetentionPolicyArgs>? = null

    private var trustPolicy: Output<TrustPolicyArgs>? = null

    /**
     * @param value The export policy for a container registry.
     */
    @JvmName("blcborighfagysec")
    public suspend fun exportPolicy(`value`: Output<ExportPolicyArgs>) {
        this.exportPolicy = value
    }

    /**
     * @param value The quarantine policy for a container registry.
     */
    @JvmName("xtawwcjxdkagrlou")
    public suspend fun quarantinePolicy(`value`: Output<QuarantinePolicyArgs>) {
        this.quarantinePolicy = value
    }

    /**
     * @param value The retention policy for a container registry.
     */
    @JvmName("vrexlejanasdihyp")
    public suspend fun retentionPolicy(`value`: Output<RetentionPolicyArgs>) {
        this.retentionPolicy = value
    }

    /**
     * @param value The content trust policy for a container registry.
     */
    @JvmName("sakfbjfsamqitdcn")
    public suspend fun trustPolicy(`value`: Output<TrustPolicyArgs>) {
        this.trustPolicy = value
    }

    /**
     * @param value The export policy for a container registry.
     */
    @JvmName("ksngdbxvruyctmqo")
    public suspend fun exportPolicy(`value`: ExportPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportPolicy = mapped
    }

    /**
     * @param argument The export policy for a container registry.
     */
    @JvmName("asnbqhffaotladvc")
    public suspend fun exportPolicy(argument: suspend ExportPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ExportPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.exportPolicy = mapped
    }

    /**
     * @param value The quarantine policy for a container registry.
     */
    @JvmName("hbtwjvdpepsrotxx")
    public suspend fun quarantinePolicy(`value`: QuarantinePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quarantinePolicy = mapped
    }

    /**
     * @param argument The quarantine policy for a container registry.
     */
    @JvmName("huquwjmbhcdpwyga")
    public suspend fun quarantinePolicy(argument: suspend QuarantinePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = QuarantinePolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.quarantinePolicy = mapped
    }

    /**
     * @param value The retention policy for a container registry.
     */
    @JvmName("xgrrtrvpmoklmape")
    public suspend fun retentionPolicy(`value`: RetentionPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPolicy = mapped
    }

    /**
     * @param argument The retention policy for a container registry.
     */
    @JvmName("rngpuxlphfkiuvgp")
    public suspend fun retentionPolicy(argument: suspend RetentionPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = RetentionPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retentionPolicy = mapped
    }

    /**
     * @param value The content trust policy for a container registry.
     */
    @JvmName("wxppgujrbayanlvd")
    public suspend fun trustPolicy(`value`: TrustPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustPolicy = mapped
    }

    /**
     * @param argument The content trust policy for a container registry.
     */
    @JvmName("nruvbvojoixaejjb")
    public suspend fun trustPolicy(argument: suspend TrustPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = TrustPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trustPolicy = mapped
    }

    internal fun build(): PoliciesArgs = PoliciesArgs(
        exportPolicy = exportPolicy,
        quarantinePolicy = quarantinePolicy,
        retentionPolicy = retentionPolicy,
        trustPolicy = trustPolicy,
    )
}
