@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.SecretObjectArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.SecretObjectType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the properties of a secret object value.
 * @property type The type of the secret object which determines how the value of the secret object has to be
 * interpreted.
 * @property value The value of the secret. The format of this value will be determined
 * based on the type of the secret object. If the type is Opaque, the value will be
 * used as is without any modification.
 */
public data class SecretObjectArgs(
    public val type: Output<Either<String, SecretObjectType>>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.SecretObjectArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.SecretObjectArgs =
        com.pulumi.azurenative.containerregistry.inputs.SecretObjectArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretObjectArgs].
 */
@PulumiTagMarker
public class SecretObjectArgsBuilder internal constructor() {
    private var type: Output<Either<String, SecretObjectType>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The type of the secret object which determines how the value of the secret object has to be
     * interpreted.
     */
    @JvmName("pjtfoworobbmshsn")
    public suspend fun type(`value`: Output<Either<String, SecretObjectType>>) {
        this.type = value
    }

    /**
     * @param value The value of the secret. The format of this value will be determined
     * based on the type of the secret object. If the type is Opaque, the value will be
     * used as is without any modification.
     */
    @JvmName("flomxcosntppqvsv")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The type of the secret object which determines how the value of the secret object has to be
     * interpreted.
     */
    @JvmName("fnoahiosvrbiyhfj")
    public suspend fun type(`value`: Either<String, SecretObjectType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the secret object which determines how the value of the secret object has to be
     * interpreted.
     */
    @JvmName("rfnvtvisnanrnfmk")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecretObjectType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the secret object which determines how the value of the secret object has to be
     * interpreted.
     */
    @JvmName("tonbdpxdbvvekrue")
    public fun type(`value`: SecretObjectType) {
        val toBeMapped = Either.ofRight<String, SecretObjectType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The value of the secret. The format of this value will be determined
     * based on the type of the secret object. If the type is Opaque, the value will be
     * used as is without any modification.
     */
    @JvmName("vgvelnptthsfwafo")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SecretObjectArgs = SecretObjectArgs(
        type = type,
        `value` = `value`,
    )
}
