@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.TrustPolicyArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.PolicyStatus
import com.pulumi.azurenative.containerregistry.kotlin.enums.TrustPolicyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The content trust policy for a container registry.
 * @property status The value that indicates whether the policy is enabled or not.
 * @property type The type of trust policy.
 */
public data class TrustPolicyArgs(
    public val status: Output<Either<String, PolicyStatus>>? = null,
    public val type: Output<Either<String, TrustPolicyType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.TrustPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.TrustPolicyArgs =
        com.pulumi.azurenative.containerregistry.inputs.TrustPolicyArgs.builder()
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TrustPolicyArgs].
 */
@PulumiTagMarker
public class TrustPolicyArgsBuilder internal constructor() {
    private var status: Output<Either<String, PolicyStatus>>? = null

    private var type: Output<Either<String, TrustPolicyType>>? = null

    /**
     * @param value The value that indicates whether the policy is enabled or not.
     */
    @JvmName("kiilhcfmnwkmajxi")
    public suspend fun status(`value`: Output<Either<String, PolicyStatus>>) {
        this.status = value
    }

    /**
     * @param value The type of trust policy.
     */
    @JvmName("xudigyjxuctktkrd")
    public suspend fun type(`value`: Output<Either<String, TrustPolicyType>>) {
        this.type = value
    }

    /**
     * @param value The value that indicates whether the policy is enabled or not.
     */
    @JvmName("qvjgvjumvbhfxhtc")
    public suspend fun status(`value`: Either<String, PolicyStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The value that indicates whether the policy is enabled or not.
     */
    @JvmName("tqsqcmakfepvdfqs")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The value that indicates whether the policy is enabled or not.
     */
    @JvmName("ntvcdnuikrbkdhcf")
    public fun status(`value`: PolicyStatus) {
        val toBeMapped = Either.ofRight<String, PolicyStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The type of trust policy.
     */
    @JvmName("sjbescludbawkweg")
    public suspend fun type(`value`: Either<String, TrustPolicyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of trust policy.
     */
    @JvmName("rwwjxmufftinsjpl")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TrustPolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of trust policy.
     */
    @JvmName("rbtvlqbogbtgmhel")
    public fun type(`value`: TrustPolicyType) {
        val toBeMapped = Either.ofRight<String, TrustPolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TrustPolicyArgs = TrustPolicyArgs(
        status = status,
        type = type,
    )
}
