@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Authentication credential stored for an upstream.
 * @property credentialHealth This provides data pertaining to the health of the auth credential.
 * @property name The name of the credential.
 * @property passwordSecretIdentifier KeyVault Secret URI for accessing the password.
 * @property usernameSecretIdentifier KeyVault Secret URI for accessing the username.
 */
public data class AuthCredentialResponse(
    public val credentialHealth: CredentialHealthResponse,
    public val name: String? = null,
    public val passwordSecretIdentifier: String? = null,
    public val usernameSecretIdentifier: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.AuthCredentialResponse):
            AuthCredentialResponse = AuthCredentialResponse(
            credentialHealth = javaType.credentialHealth().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.CredentialHealthResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            passwordSecretIdentifier = javaType.passwordSecretIdentifier().map({ args0 -> args0 }).orElse(null),
            usernameSecretIdentifier = javaType.usernameSecretIdentifier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
