@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An object that represents an export pipeline for a container registry.
 * @property archiveVersionErrorMessage The detailed error message for the archive version in the case of failure.
 * @property id The resource ID.
 * @property name The name of the resource.
 * @property provisioningState The provisioning state of the archive at the time the operation was called.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource.
 */
public data class GetArchiveVersionResult(
    public val archiveVersionErrorMessage: String? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.GetArchiveVersionResult):
            GetArchiveVersionResult = GetArchiveVersionResult(
            archiveVersionErrorMessage = javaType.archiveVersionErrorMessage().map({ args0 ->
                args0
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
