@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An object that represents a scope map for a container registry.
 * @property actions The list of scoped permissions for registry artifacts.
 * E.g. repositories/repository-name/content/read,
 * repositories/repository-name/metadata/write
 * @property creationDate The creation date of scope map.
 * @property description The user friendly description of the scope map.
 * @property id The resource ID.
 * @property name The name of the resource.
 * @property provisioningState Provisioning state of the resource.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource.
 */
public data class GetScopeMapResult(
    public val actions: List<String>,
    public val creationDate: String,
    public val description: String? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.GetScopeMapResult):
            GetScopeMapResult = GetScopeMapResult(
            actions = javaType.actions().map({ args0 -> args0 }),
            creationDate = javaType.creationDate(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
