@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The result of a request to list events for a webhook.
 * @property nextLink The URI that can be used to request the next list of events.
 * @property value The list of events. Since this list may be incomplete, the nextLink field should be used to request the next list of events.
 */
public data class ListWebhookEventsResult(
    public val nextLink: String? = null,
    public val `value`: List<EventResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.ListWebhookEventsResult):
            ListWebhookEventsResult = ListWebhookEventsResult(
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.EventResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
