@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The login server properties of the connected registry.
 * @property host The host of the connected registry. Can be FQDN or IP.
 * @property tls The TLS properties of the connected registry login server.
 */
public data class LoginServerPropertiesResponse(
    public val host: String,
    public val tls: TlsPropertiesResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.LoginServerPropertiesResponse):
            LoginServerPropertiesResponse = LoginServerPropertiesResponse(
            host = javaType.host(),
            tls = javaType.tls().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.TlsPropertiesResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
