@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The properties of a overridable value that can be passed to a task template.
 * @property isSecret Flag to indicate whether the value represents a secret or not.
 * @property name The name of the overridable value.
 * @property value The overridable value.
 */
public data class SetValueResponse(
    public val isSecret: Boolean? = null,
    public val name: String,
    public val `value`: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.SetValueResponse):
            SetValueResponse = SetValueResponse(
            isSecret = javaType.isSecret().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            `value` = javaType.`value`(),
        )
    }
}
