@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of the source code repository.
 * @property branch The branch name of the source code.
 * @property repositoryUrl The full URL to the source code repository
 * @property sourceControlAuthProperties The authorization properties for accessing the source code repository and to set up
 * webhooks for notifications.
 * @property sourceControlType The type of source control service.
 */
public data class SourcePropertiesResponse(
    public val branch: String? = null,
    public val repositoryUrl: String,
    public val sourceControlAuthProperties: AuthInfoResponse? = null,
    public val sourceControlType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.SourcePropertiesResponse):
            SourcePropertiesResponse = SourcePropertiesResponse(
            branch = javaType.branch().map({ args0 -> args0 }).orElse(null),
            repositoryUrl = javaType.repositoryUrl(),
            sourceControlAuthProperties = javaType.sourceControlAuthProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.AuthInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sourceControlType = javaType.sourceControlType(),
        )
    }
}
