@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The source trigger that caused a run.
 * @property branchName The branch name in the repository.
 * @property commitId The unique ID that identifies a commit.
 * @property eventType The event type of the trigger.
 * @property id The unique ID of the trigger.
 * @property providerType The source control provider type.
 * @property pullRequestId The unique ID that identifies pull request.
 * @property repositoryUrl The repository URL.
 */
public data class SourceTriggerDescriptorResponse(
    public val branchName: String? = null,
    public val commitId: String? = null,
    public val eventType: String? = null,
    public val id: String? = null,
    public val providerType: String? = null,
    public val pullRequestId: String? = null,
    public val repositoryUrl: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.SourceTriggerDescriptorResponse):
            SourceTriggerDescriptorResponse = SourceTriggerDescriptorResponse(
            branchName = javaType.branchName().map({ args0 -> args0 }).orElse(null),
            commitId = javaType.commitId().map({ args0 -> args0 }).orElse(null),
            eventType = javaType.eventType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            providerType = javaType.providerType().map({ args0 -> args0 }).orElse(null),
            pullRequestId = javaType.pullRequestId().map({ args0 -> args0 }).orElse(null),
            repositoryUrl = javaType.repositoryUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
