@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.FleetArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.inputs.FleetHubProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.FleetHubProfileArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Fleet resource.
 * Azure REST API version: 2023-03-15-preview.
 * Other available API versions: 2022-07-02-preview, 2023-06-15-preview, 2023-08-15-preview, 2023-10-15, 2024-02-02-preview.
 * ## Example Usage
 * ### Creates a Fleet resource with a long running operation.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fleet = new AzureNative.ContainerService.Fleet("fleet", new()
 *     {
 *         FleetName = "fleet1",
 *         HubProfile = new AzureNative.ContainerService.Inputs.FleetHubProfileArgs
 *         {
 *             DnsPrefix = "dnsprefix1",
 *         },
 *         Location = "East US",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewFleet(ctx, "fleet", &containerservice.FleetArgs{
 * 			FleetName: pulumi.String("fleet1"),
 * 			HubProfile: &containerservice.FleetHubProfileArgs{
 * 				DnsPrefix: pulumi.String("dnsprefix1"),
 * 			},
 * 			Location:          pulumi.String("East US"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.Fleet;
 * import com.pulumi.azurenative.containerservice.FleetArgs;
 * import com.pulumi.azurenative.containerservice.inputs.FleetHubProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fleet = new Fleet("fleet", FleetArgs.builder()
 *             .fleetName("fleet1")
 *             .hubProfile(FleetHubProfileArgs.builder()
 *                 .dnsPrefix("dnsprefix1")
 *                 .build())
 *             .location("East US")
 *             .resourceGroupName("rg1")
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:Fleet fleet-1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}
 * ```
 * @property fleetName The name of the Fleet resource.
 * @property hubProfile The FleetHubProfile configures the Fleet's hub.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class FleetArgs(
    public val fleetName: Output<String>? = null,
    public val hubProfile: Output<FleetHubProfileArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.FleetArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.FleetArgs =
        com.pulumi.azurenative.containerservice.FleetArgs.builder()
            .fleetName(fleetName?.applyValue({ args0 -> args0 }))
            .hubProfile(hubProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FleetArgs].
 */
@PulumiTagMarker
public class FleetArgsBuilder internal constructor() {
    private var fleetName: Output<String>? = null

    private var hubProfile: Output<FleetHubProfileArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Fleet resource.
     */
    @JvmName("mgmqsdwpkjcqgufw")
    public suspend fun fleetName(`value`: Output<String>) {
        this.fleetName = value
    }

    /**
     * @param value The FleetHubProfile configures the Fleet's hub.
     */
    @JvmName("tlxcgvblnoadjqch")
    public suspend fun hubProfile(`value`: Output<FleetHubProfileArgs>) {
        this.hubProfile = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jcyqecanvlhgdhlw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tdjhymaneelyxvky")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tiaucgwdebetwdcv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Fleet resource.
     */
    @JvmName("rktbrkfduqfubfxk")
    public suspend fun fleetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fleetName = mapped
    }

    /**
     * @param value The FleetHubProfile configures the Fleet's hub.
     */
    @JvmName("yridlsysmjcapggn")
    public suspend fun hubProfile(`value`: FleetHubProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hubProfile = mapped
    }

    /**
     * @param argument The FleetHubProfile configures the Fleet's hub.
     */
    @JvmName("jnugvfyadumeubfm")
    public suspend fun hubProfile(argument: suspend FleetHubProfileArgsBuilder.() -> Unit) {
        val toBeMapped = FleetHubProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hubProfile = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ryldhsranoxhveab")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cjjumhpkwieetelu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vpcvgfjikfknajbk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("dvpbelbqjqwyryso")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FleetArgs = FleetArgs(
        fleetName = fleetName,
        hubProfile = hubProfile,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
