@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The IP version to use for cluster networking and IP assignment.
 */
public enum class IpFamily(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.IpFamily,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.IpFamily> {
    IPv4(com.pulumi.azurenative.containerservice.enums.IpFamily.IPv4),
    IPv6(com.pulumi.azurenative.containerservice.enums.IpFamily.IPv6),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.IpFamily = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.IpFamily): IpFamily =
            IpFamily.values().first { it.javaValue == javaType }
    }
}
