@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
 */
public enum class OSType(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.OSType,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.OSType> {
    Linux(com.pulumi.azurenative.containerservice.enums.OSType.Linux),
    Windows(com.pulumi.azurenative.containerservice.enums.OSType.Windows),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.OSType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.OSType): OSType =
            OSType.values().first { it.javaValue == javaType }
    }
}
