@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This can only be set at cluster creation time and cannot be changed later. For more information see [egress outbound type](https://docs.microsoft.com/azure/aks/egress-outboundtype).
 */
public enum class OutboundType(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.OutboundType,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.OutboundType> {
    /**
     * The load balancer is used for egress through an AKS assigned public IP. This supports Kubernetes services of type 'loadBalancer'. For more information see [outbound type loadbalancer](https://docs.microsoft.com/azure/aks/egress-outboundtype#outbound-type-of-loadbalancer).
     */
    LoadBalancer(com.pulumi.azurenative.containerservice.enums.OutboundType.LoadBalancer),

    /**
     * Egress paths must be defined by the user. This is an advanced scenario and requires proper network configuration. For more information see [outbound type userDefinedRouting](https://docs.microsoft.com/azure/aks/egress-outboundtype#outbound-type-of-userdefinedrouting).
     */
    UserDefinedRouting(com.pulumi.azurenative.containerservice.enums.OutboundType.UserDefinedRouting),

    /**
     * The AKS-managed NAT gateway is used for egress.
     */
    ManagedNATGateway(com.pulumi.azurenative.containerservice.enums.OutboundType.ManagedNATGateway),

    /**
     * The user-assigned NAT gateway associated to the cluster subnet is used for egress. This is an advanced scenario and requires proper network configuration.
     */
    UserAssignedNATGateway(com.pulumi.azurenative.containerservice.enums.OutboundType.UserAssignedNATGateway),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.OutboundType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.OutboundType):
            OutboundType = OutboundType.values().first { it.javaValue == javaType }
    }
}
