@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'.
 */
public enum class ScaleSetPriority(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.ScaleSetPriority,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.ScaleSetPriority> {
    /**
     * Spot priority VMs will be used. There is no SLA for spot nodes. See [spot on AKS](https://docs.microsoft.com/azure/aks/spot-node-pool) for more information.
     */
    Spot(com.pulumi.azurenative.containerservice.enums.ScaleSetPriority.Spot),

    /**
     * Regular VMs will be used.
     */
    Regular(com.pulumi.azurenative.containerservice.enums.ScaleSetPriority.Regular),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.ScaleSetPriority = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.ScaleSetPriority):
            ScaleSetPriority = ScaleSetPriority.values().first { it.javaValue == javaType }
    }
}
