@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.CreationDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Data used when creating a target resource from a source resource.
 * @property sourceResourceId This is the ARM ID of the source object to be used to create the target object.
 */
public data class CreationDataArgs(
    public val sourceResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.CreationDataArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.CreationDataArgs =
        com.pulumi.azurenative.containerservice.inputs.CreationDataArgs.builder()
            .sourceResourceId(sourceResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CreationDataArgs].
 */
@PulumiTagMarker
public class CreationDataArgsBuilder internal constructor() {
    private var sourceResourceId: Output<String>? = null

    /**
     * @param value This is the ARM ID of the source object to be used to create the target object.
     */
    @JvmName("esnrralcsrnawupp")
    public suspend fun sourceResourceId(`value`: Output<String>) {
        this.sourceResourceId = value
    }

    /**
     * @param value This is the ARM ID of the source object to be used to create the target object.
     */
    @JvmName("xeqbebgpgcpigmlf")
    public suspend fun sourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceId = mapped
    }

    internal fun build(): CreationDataArgs = CreationDataArgs(
        sourceResourceId = sourceResourceId,
    )
}
