@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.FleetHubProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The FleetHubProfile configures the fleet hub.
 * @property dnsPrefix DNS prefix used to create the FQDN for the Fleet hub.
 */
public data class FleetHubProfileArgs(
    public val dnsPrefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.FleetHubProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.FleetHubProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.FleetHubProfileArgs.builder()
            .dnsPrefix(dnsPrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetHubProfileArgs].
 */
@PulumiTagMarker
public class FleetHubProfileArgsBuilder internal constructor() {
    private var dnsPrefix: Output<String>? = null

    /**
     * @param value DNS prefix used to create the FQDN for the Fleet hub.
     */
    @JvmName("gskthmmkvnlcwfws")
    public suspend fun dnsPrefix(`value`: Output<String>) {
        this.dnsPrefix = value
    }

    /**
     * @param value DNS prefix used to create the FQDN for the Fleet hub.
     */
    @JvmName("xcqidsmnnhwjrmjh")
    public suspend fun dnsPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsPrefix = mapped
    }

    internal fun build(): FleetHubProfileArgs = FleetHubProfileArgs(
        dnsPrefix = dnsPrefix,
    )
}
