@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.GetAgentPoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property agentPoolName The name of the agent pool.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the managed cluster resource.
 */
public data class GetAgentPoolPlainArgs(
    public val agentPoolName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.GetAgentPoolPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.GetAgentPoolPlainArgs =
        com.pulumi.azurenative.containerservice.inputs.GetAgentPoolPlainArgs.builder()
            .agentPoolName(agentPoolName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAgentPoolPlainArgs].
 */
@PulumiTagMarker
public class GetAgentPoolPlainArgsBuilder internal constructor() {
    private var agentPoolName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the agent pool.
     */
    @JvmName("sjgtwfvcbidumfsc")
    public suspend fun agentPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.agentPoolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gxoowrcxuftsknwb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("ymrfbuituusrqnbm")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetAgentPoolPlainArgs = GetAgentPoolPlainArgs(
        agentPoolName = agentPoolName ?: throw PulumiNullFieldException("agentPoolName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
