@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.GetFleetMemberPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fleetMemberName The name of the Fleet member resource.
 * @property fleetName The name of the Fleet resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetFleetMemberPlainArgs(
    public val fleetMemberName: String,
    public val fleetName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.GetFleetMemberPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.GetFleetMemberPlainArgs =
        com.pulumi.azurenative.containerservice.inputs.GetFleetMemberPlainArgs.builder()
            .fleetMemberName(fleetMemberName.let({ args0 -> args0 }))
            .fleetName(fleetName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFleetMemberPlainArgs].
 */
@PulumiTagMarker
public class GetFleetMemberPlainArgsBuilder internal constructor() {
    private var fleetMemberName: String? = null

    private var fleetName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Fleet member resource.
     */
    @JvmName("ludbtkwcnswvrdyq")
    public suspend fun fleetMemberName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fleetMemberName = mapped
    }

    /**
     * @param value The name of the Fleet resource.
     */
    @JvmName("ptaseqlrybaxlfhh")
    public suspend fun fleetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fleetName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hjlmjtjrvrsefqfb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetFleetMemberPlainArgs = GetFleetMemberPlainArgs(
        fleetMemberName = fleetMemberName ?: throw PulumiNullFieldException("fleetMemberName"),
        fleetName = fleetName ?: throw PulumiNullFieldException("fleetName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
