@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.GetTrustedAccessRoleBindingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the managed cluster resource.
 * @property trustedAccessRoleBindingName The name of trusted access role binding.
 */
public data class GetTrustedAccessRoleBindingPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
    public val trustedAccessRoleBindingName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.GetTrustedAccessRoleBindingPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.GetTrustedAccessRoleBindingPlainArgs =
        com.pulumi.azurenative.containerservice.inputs.GetTrustedAccessRoleBindingPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 }))
            .trustedAccessRoleBindingName(trustedAccessRoleBindingName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrustedAccessRoleBindingPlainArgs].
 */
@PulumiTagMarker
public class GetTrustedAccessRoleBindingPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    private var trustedAccessRoleBindingName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("imisksgscibplcqq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("xwrvkxutinsaxdkn")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    /**
     * @param value The name of trusted access role binding.
     */
    @JvmName("jfeficermcvafemk")
    public suspend fun trustedAccessRoleBindingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.trustedAccessRoleBindingName = mapped
    }

    internal fun build(): GetTrustedAccessRoleBindingPlainArgs = GetTrustedAccessRoleBindingPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        trustedAccessRoleBindingName = trustedAccessRoleBindingName ?: throw
            PulumiNullFieldException("trustedAccessRoleBindingName"),
    )
}
