@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.GetUpdateRunPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fleetName The name of the Fleet resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property updateRunName The name of the UpdateRun resource.
 */
public data class GetUpdateRunPlainArgs(
    public val fleetName: String,
    public val resourceGroupName: String,
    public val updateRunName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.GetUpdateRunPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.GetUpdateRunPlainArgs =
        com.pulumi.azurenative.containerservice.inputs.GetUpdateRunPlainArgs.builder()
            .fleetName(fleetName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .updateRunName(updateRunName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUpdateRunPlainArgs].
 */
@PulumiTagMarker
public class GetUpdateRunPlainArgsBuilder internal constructor() {
    private var fleetName: String? = null

    private var resourceGroupName: String? = null

    private var updateRunName: String? = null

    /**
     * @param value The name of the Fleet resource.
     */
    @JvmName("utkkryienpjmcnko")
    public suspend fun fleetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fleetName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ltkbofgssekkxibu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the UpdateRun resource.
     */
    @JvmName("yrorcmdlkxonjerv")
    public suspend fun updateRunName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.updateRunName = mapped
    }

    internal fun build(): GetUpdateRunPlainArgs = GetUpdateRunPlainArgs(
        fleetName = fleetName ?: throw PulumiNullFieldException("fleetName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        updateRunName = updateRunName ?: throw PulumiNullFieldException("updateRunName"),
    )
}
