@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.KubeletConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * See [AKS custom node configuration](https://docs.microsoft.com/azure/aks/custom-node-configuration) for more details.
 * @property allowedUnsafeSysctls Allowed list of unsafe sysctls or unsafe sysctl patterns (ending in `*`).
 * @property containerLogMaxFiles The maximum number of container log files that can be present for a container. The number must be ≥ 2.
 * @property containerLogMaxSizeMB The maximum size (e.g. 10Mi) of container log file before it is rotated.
 * @property cpuCfsQuota The default is true.
 * @property cpuCfsQuotaPeriod The default is '100ms.' Valid values are a sequence of decimal numbers with an optional fraction and a unit suffix. For example: '300ms', '2h45m'. Supported units are 'ns', 'us', 'ms', 's', 'm', and 'h'.
 * @property cpuManagerPolicy The default is 'none'. See [Kubernetes CPU management policies](https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/#cpu-management-policies) for more information. Allowed values are 'none' and 'static'.
 * @property failSwapOn If set to true it will make the Kubelet fail to start if swap is enabled on the node.
 * @property imageGcHighThreshold To disable image garbage collection, set to 100. The default is 85%
 * @property imageGcLowThreshold This cannot be set higher than imageGcHighThreshold. The default is 80%
 * @property podMaxPids The maximum number of processes per pod.
 * @property topologyManagerPolicy For more information see [Kubernetes Topology Manager](https://kubernetes.io/docs/tasks/administer-cluster/topology-manager). The default is 'none'. Allowed values are 'none', 'best-effort', 'restricted', and 'single-numa-node'.
 */
public data class KubeletConfigArgs(
    public val allowedUnsafeSysctls: Output<List<String>>? = null,
    public val containerLogMaxFiles: Output<Int>? = null,
    public val containerLogMaxSizeMB: Output<Int>? = null,
    public val cpuCfsQuota: Output<Boolean>? = null,
    public val cpuCfsQuotaPeriod: Output<String>? = null,
    public val cpuManagerPolicy: Output<String>? = null,
    public val failSwapOn: Output<Boolean>? = null,
    public val imageGcHighThreshold: Output<Int>? = null,
    public val imageGcLowThreshold: Output<Int>? = null,
    public val podMaxPids: Output<Int>? = null,
    public val topologyManagerPolicy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.KubeletConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.KubeletConfigArgs =
        com.pulumi.azurenative.containerservice.inputs.KubeletConfigArgs.builder()
            .allowedUnsafeSysctls(allowedUnsafeSysctls?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .containerLogMaxFiles(containerLogMaxFiles?.applyValue({ args0 -> args0 }))
            .containerLogMaxSizeMB(containerLogMaxSizeMB?.applyValue({ args0 -> args0 }))
            .cpuCfsQuota(cpuCfsQuota?.applyValue({ args0 -> args0 }))
            .cpuCfsQuotaPeriod(cpuCfsQuotaPeriod?.applyValue({ args0 -> args0 }))
            .cpuManagerPolicy(cpuManagerPolicy?.applyValue({ args0 -> args0 }))
            .failSwapOn(failSwapOn?.applyValue({ args0 -> args0 }))
            .imageGcHighThreshold(imageGcHighThreshold?.applyValue({ args0 -> args0 }))
            .imageGcLowThreshold(imageGcLowThreshold?.applyValue({ args0 -> args0 }))
            .podMaxPids(podMaxPids?.applyValue({ args0 -> args0 }))
            .topologyManagerPolicy(topologyManagerPolicy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KubeletConfigArgs].
 */
@PulumiTagMarker
public class KubeletConfigArgsBuilder internal constructor() {
    private var allowedUnsafeSysctls: Output<List<String>>? = null

    private var containerLogMaxFiles: Output<Int>? = null

    private var containerLogMaxSizeMB: Output<Int>? = null

    private var cpuCfsQuota: Output<Boolean>? = null

    private var cpuCfsQuotaPeriod: Output<String>? = null

    private var cpuManagerPolicy: Output<String>? = null

    private var failSwapOn: Output<Boolean>? = null

    private var imageGcHighThreshold: Output<Int>? = null

    private var imageGcLowThreshold: Output<Int>? = null

    private var podMaxPids: Output<Int>? = null

    private var topologyManagerPolicy: Output<String>? = null

    /**
     * @param value Allowed list of unsafe sysctls or unsafe sysctl patterns (ending in `*`).
     */
    @JvmName("egakngpsvhekwjnd")
    public suspend fun allowedUnsafeSysctls(`value`: Output<List<String>>) {
        this.allowedUnsafeSysctls = value
    }

    @JvmName("kcfyvmwcqymtetcd")
    public suspend fun allowedUnsafeSysctls(vararg values: Output<String>) {
        this.allowedUnsafeSysctls = Output.all(values.asList())
    }

    /**
     * @param values Allowed list of unsafe sysctls or unsafe sysctl patterns (ending in `*`).
     */
    @JvmName("wwtbppdeloimxyyi")
    public suspend fun allowedUnsafeSysctls(values: List<Output<String>>) {
        this.allowedUnsafeSysctls = Output.all(values)
    }

    /**
     * @param value The maximum number of container log files that can be present for a container. The number must be ≥ 2.
     */
    @JvmName("jalwdismnpxbuyjg")
    public suspend fun containerLogMaxFiles(`value`: Output<Int>) {
        this.containerLogMaxFiles = value
    }

    /**
     * @param value The maximum size (e.g. 10Mi) of container log file before it is rotated.
     */
    @JvmName("yjbhyxuluttjbqbr")
    public suspend fun containerLogMaxSizeMB(`value`: Output<Int>) {
        this.containerLogMaxSizeMB = value
    }

    /**
     * @param value The default is true.
     */
    @JvmName("xngmlskxgrfumvuw")
    public suspend fun cpuCfsQuota(`value`: Output<Boolean>) {
        this.cpuCfsQuota = value
    }

    /**
     * @param value The default is '100ms.' Valid values are a sequence of decimal numbers with an optional fraction and a unit suffix. For example: '300ms', '2h45m'. Supported units are 'ns', 'us', 'ms', 's', 'm', and 'h'.
     */
    @JvmName("agfesngvpwjlvwlk")
    public suspend fun cpuCfsQuotaPeriod(`value`: Output<String>) {
        this.cpuCfsQuotaPeriod = value
    }

    /**
     * @param value The default is 'none'. See [Kubernetes CPU management policies](https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/#cpu-management-policies) for more information. Allowed values are 'none' and 'static'.
     */
    @JvmName("dyfmvqdhaqucetlx")
    public suspend fun cpuManagerPolicy(`value`: Output<String>) {
        this.cpuManagerPolicy = value
    }

    /**
     * @param value If set to true it will make the Kubelet fail to start if swap is enabled on the node.
     */
    @JvmName("ujwqppefmwynqlum")
    public suspend fun failSwapOn(`value`: Output<Boolean>) {
        this.failSwapOn = value
    }

    /**
     * @param value To disable image garbage collection, set to 100. The default is 85%
     */
    @JvmName("qkyqonexpuieytna")
    public suspend fun imageGcHighThreshold(`value`: Output<Int>) {
        this.imageGcHighThreshold = value
    }

    /**
     * @param value This cannot be set higher than imageGcHighThreshold. The default is 80%
     */
    @JvmName("cvctafwpvssmerfj")
    public suspend fun imageGcLowThreshold(`value`: Output<Int>) {
        this.imageGcLowThreshold = value
    }

    /**
     * @param value The maximum number of processes per pod.
     */
    @JvmName("rihotkvkkfrkuflr")
    public suspend fun podMaxPids(`value`: Output<Int>) {
        this.podMaxPids = value
    }

    /**
     * @param value For more information see [Kubernetes Topology Manager](https://kubernetes.io/docs/tasks/administer-cluster/topology-manager). The default is 'none'. Allowed values are 'none', 'best-effort', 'restricted', and 'single-numa-node'.
     */
    @JvmName("qfksujwvevkgqogc")
    public suspend fun topologyManagerPolicy(`value`: Output<String>) {
        this.topologyManagerPolicy = value
    }

    /**
     * @param value Allowed list of unsafe sysctls or unsafe sysctl patterns (ending in `*`).
     */
    @JvmName("bgcnoqqqqrrgyyam")
    public suspend fun allowedUnsafeSysctls(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedUnsafeSysctls = mapped
    }

    /**
     * @param values Allowed list of unsafe sysctls or unsafe sysctl patterns (ending in `*`).
     */
    @JvmName("qohuprxhpfimmeeg")
    public suspend fun allowedUnsafeSysctls(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedUnsafeSysctls = mapped
    }

    /**
     * @param value The maximum number of container log files that can be present for a container. The number must be ≥ 2.
     */
    @JvmName("ylmgwothusgkjcaj")
    public suspend fun containerLogMaxFiles(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerLogMaxFiles = mapped
    }

    /**
     * @param value The maximum size (e.g. 10Mi) of container log file before it is rotated.
     */
    @JvmName("kjrasikcqydpqklb")
    public suspend fun containerLogMaxSizeMB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerLogMaxSizeMB = mapped
    }

    /**
     * @param value The default is true.
     */
    @JvmName("rtcsvcvjykbewlxq")
    public suspend fun cpuCfsQuota(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuCfsQuota = mapped
    }

    /**
     * @param value The default is '100ms.' Valid values are a sequence of decimal numbers with an optional fraction and a unit suffix. For example: '300ms', '2h45m'. Supported units are 'ns', 'us', 'ms', 's', 'm', and 'h'.
     */
    @JvmName("ccoejmcjvhgevywk")
    public suspend fun cpuCfsQuotaPeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuCfsQuotaPeriod = mapped
    }

    /**
     * @param value The default is 'none'. See [Kubernetes CPU management policies](https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/#cpu-management-policies) for more information. Allowed values are 'none' and 'static'.
     */
    @JvmName("fjgjsmhwjotlhlmp")
    public suspend fun cpuManagerPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuManagerPolicy = mapped
    }

    /**
     * @param value If set to true it will make the Kubelet fail to start if swap is enabled on the node.
     */
    @JvmName("alshjafgxianaekl")
    public suspend fun failSwapOn(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failSwapOn = mapped
    }

    /**
     * @param value To disable image garbage collection, set to 100. The default is 85%
     */
    @JvmName("upksuprggymyboie")
    public suspend fun imageGcHighThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageGcHighThreshold = mapped
    }

    /**
     * @param value This cannot be set higher than imageGcHighThreshold. The default is 80%
     */
    @JvmName("lcuwwicwbhyjehmn")
    public suspend fun imageGcLowThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageGcLowThreshold = mapped
    }

    /**
     * @param value The maximum number of processes per pod.
     */
    @JvmName("qhchiwaqtryoccxb")
    public suspend fun podMaxPids(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.podMaxPids = mapped
    }

    /**
     * @param value For more information see [Kubernetes Topology Manager](https://kubernetes.io/docs/tasks/administer-cluster/topology-manager). The default is 'none'. Allowed values are 'none', 'best-effort', 'restricted', and 'single-numa-node'.
     */
    @JvmName("rwfqjkutqxgxngex")
    public suspend fun topologyManagerPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topologyManagerPolicy = mapped
    }

    internal fun build(): KubeletConfigArgs = KubeletConfigArgs(
        allowedUnsafeSysctls = allowedUnsafeSysctls,
        containerLogMaxFiles = containerLogMaxFiles,
        containerLogMaxSizeMB = containerLogMaxSizeMB,
        cpuCfsQuota = cpuCfsQuota,
        cpuCfsQuotaPeriod = cpuCfsQuotaPeriod,
        cpuManagerPolicy = cpuManagerPolicy,
        failSwapOn = failSwapOn,
        imageGcHighThreshold = imageGcHighThreshold,
        imageGcLowThreshold = imageGcLowThreshold,
        podMaxPids = podMaxPids,
        topologyManagerPolicy = topologyManagerPolicy,
    )
}
