@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.LinuxOSConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * See [AKS custom node configuration](https://docs.microsoft.com/azure/aks/custom-node-configuration) for more details.
 * @property swapFileSizeMB The size in MB of a swap file that will be created on each node.
 * @property sysctls Sysctl settings for Linux agent nodes.
 * @property transparentHugePageDefrag Valid values are 'always', 'defer', 'defer+madvise', 'madvise' and 'never'. The default is 'madvise'. For more information see [Transparent Hugepages](https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge).
 * @property transparentHugePageEnabled Valid values are 'always', 'madvise', and 'never'. The default is 'always'. For more information see [Transparent Hugepages](https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge).
 */
public data class LinuxOSConfigArgs(
    public val swapFileSizeMB: Output<Int>? = null,
    public val sysctls: Output<SysctlConfigArgs>? = null,
    public val transparentHugePageDefrag: Output<String>? = null,
    public val transparentHugePageEnabled: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.LinuxOSConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.LinuxOSConfigArgs =
        com.pulumi.azurenative.containerservice.inputs.LinuxOSConfigArgs.builder()
            .swapFileSizeMB(swapFileSizeMB?.applyValue({ args0 -> args0 }))
            .sysctls(sysctls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .transparentHugePageDefrag(transparentHugePageDefrag?.applyValue({ args0 -> args0 }))
            .transparentHugePageEnabled(transparentHugePageEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinuxOSConfigArgs].
 */
@PulumiTagMarker
public class LinuxOSConfigArgsBuilder internal constructor() {
    private var swapFileSizeMB: Output<Int>? = null

    private var sysctls: Output<SysctlConfigArgs>? = null

    private var transparentHugePageDefrag: Output<String>? = null

    private var transparentHugePageEnabled: Output<String>? = null

    /**
     * @param value The size in MB of a swap file that will be created on each node.
     */
    @JvmName("wnbqneoikosyssff")
    public suspend fun swapFileSizeMB(`value`: Output<Int>) {
        this.swapFileSizeMB = value
    }

    /**
     * @param value Sysctl settings for Linux agent nodes.
     */
    @JvmName("leyqcegfykknlpgp")
    public suspend fun sysctls(`value`: Output<SysctlConfigArgs>) {
        this.sysctls = value
    }

    /**
     * @param value Valid values are 'always', 'defer', 'defer+madvise', 'madvise' and 'never'. The default is 'madvise'. For more information see [Transparent Hugepages](https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge).
     */
    @JvmName("kpoxfroagukqinim")
    public suspend fun transparentHugePageDefrag(`value`: Output<String>) {
        this.transparentHugePageDefrag = value
    }

    /**
     * @param value Valid values are 'always', 'madvise', and 'never'. The default is 'always'. For more information see [Transparent Hugepages](https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge).
     */
    @JvmName("ypvcawliaoboplqg")
    public suspend fun transparentHugePageEnabled(`value`: Output<String>) {
        this.transparentHugePageEnabled = value
    }

    /**
     * @param value The size in MB of a swap file that will be created on each node.
     */
    @JvmName("jtiyfysabwpmghmw")
    public suspend fun swapFileSizeMB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.swapFileSizeMB = mapped
    }

    /**
     * @param value Sysctl settings for Linux agent nodes.
     */
    @JvmName("bnqvpearbghjesrg")
    public suspend fun sysctls(`value`: SysctlConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sysctls = mapped
    }

    /**
     * @param argument Sysctl settings for Linux agent nodes.
     */
    @JvmName("hrbwccdglwbvosjm")
    public suspend fun sysctls(argument: suspend SysctlConfigArgsBuilder.() -> Unit) {
        val toBeMapped = SysctlConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sysctls = mapped
    }

    /**
     * @param value Valid values are 'always', 'defer', 'defer+madvise', 'madvise' and 'never'. The default is 'madvise'. For more information see [Transparent Hugepages](https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge).
     */
    @JvmName("xgdkunurpnerfxkt")
    public suspend fun transparentHugePageDefrag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transparentHugePageDefrag = mapped
    }

    /**
     * @param value Valid values are 'always', 'madvise', and 'never'. The default is 'always'. For more information see [Transparent Hugepages](https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge).
     */
    @JvmName("hgslisjsrekfxaqx")
    public suspend fun transparentHugePageEnabled(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transparentHugePageEnabled = mapped
    }

    internal fun build(): LinuxOSConfigArgs = LinuxOSConfigArgs(
        swapFileSizeMB = swapFileSizeMB,
        sysctls = sysctls,
        transparentHugePageDefrag = transparentHugePageDefrag,
        transparentHugePageEnabled = transparentHugePageEnabled,
    )
}
