@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ListFleetCredentialsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fleetName The name of the Fleet resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListFleetCredentialsPlainArgs(
    public val fleetName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ListFleetCredentialsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ListFleetCredentialsPlainArgs =
        com.pulumi.azurenative.containerservice.inputs.ListFleetCredentialsPlainArgs.builder()
            .fleetName(fleetName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListFleetCredentialsPlainArgs].
 */
@PulumiTagMarker
public class ListFleetCredentialsPlainArgsBuilder internal constructor() {
    private var fleetName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Fleet resource.
     */
    @JvmName("mlblsbtugvciklut")
    public suspend fun fleetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fleetName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("avgjgcvbavfbhsoq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListFleetCredentialsPlainArgs = ListFleetCredentialsPlainArgs(
        fleetName = fleetName ?: throw PulumiNullFieldException("fleetName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
