@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ListManagedClusterAccessProfilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property resourceName The name of the managed cluster resource.
 * @property roleName The name of the role for managed cluster accessProfile resource.
 */
public data class ListManagedClusterAccessProfilePlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
    public val roleName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ListManagedClusterAccessProfilePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ListManagedClusterAccessProfilePlainArgs =
        com.pulumi.azurenative.containerservice.inputs.ListManagedClusterAccessProfilePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 }))
            .roleName(roleName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListManagedClusterAccessProfilePlainArgs].
 */
@PulumiTagMarker
public class ListManagedClusterAccessProfilePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    private var roleName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("iilumbpbmejrtngn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("vquulnwtkjfsbjpq")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    /**
     * @param value The name of the role for managed cluster accessProfile resource.
     */
    @JvmName("vbjfpikogeylnsfc")
    public suspend fun roleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.roleName = mapped
    }

    internal fun build(): ListManagedClusterAccessProfilePlainArgs =
        ListManagedClusterAccessProfilePlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
            roleName = roleName ?: throw PulumiNullFieldException("roleName"),
        )
}
