@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAzureMonitorProfileKubeStateMetricsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Kube State Metrics profile for the Azure Managed Prometheus addon. These optional settings are for the kube-state-metrics pod that is deployed with the addon. See aka.ms/AzureManagedPrometheus-optional-parameters for details.
 * @property metricAnnotationsAllowList Comma-separated list of Kubernetes annotation keys that will be used in the resource's labels metric (Example: 'namespaces=[kubernetes&#46;io/team,&#46;&#46;&#46;],pods=[kubernetes&#46;io/team],...'). By default the metric contains only resource name and namespace labels.
 * @property metricLabelsAllowlist Comma-separated list of additional Kubernetes label keys that will be used in the resource's labels metric (Example: 'namespaces=[k8s-label-1,k8s-label-n,&#46;&#46;&#46;],pods=[app],...'). By default the metric contains only resource name and namespace labels.
 */
public data class ManagedClusterAzureMonitorProfileKubeStateMetricsArgs(
    public val metricAnnotationsAllowList: Output<String>? = null,
    public val metricLabelsAllowlist: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterAzureMonitorProfileKubeStateMetricsArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterAzureMonitorProfileKubeStateMetricsArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterAzureMonitorProfileKubeStateMetricsArgs.builder()
            .metricAnnotationsAllowList(metricAnnotationsAllowList?.applyValue({ args0 -> args0 }))
            .metricLabelsAllowlist(metricLabelsAllowlist?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedClusterAzureMonitorProfileKubeStateMetricsArgs].
 */
@PulumiTagMarker
public class ManagedClusterAzureMonitorProfileKubeStateMetricsArgsBuilder internal constructor() {
    private var metricAnnotationsAllowList: Output<String>? = null

    private var metricLabelsAllowlist: Output<String>? = null

    /**
     * @param value Comma-separated list of Kubernetes annotation keys that will be used in the resource's labels metric (Example: 'namespaces=[kubernetes&#46;io/team,&#46;&#46;&#46;],pods=[kubernetes&#46;io/team],...'). By default the metric contains only resource name and namespace labels.
     */
    @JvmName("vbvgdakpuysquhaa")
    public suspend fun metricAnnotationsAllowList(`value`: Output<String>) {
        this.metricAnnotationsAllowList = value
    }

    /**
     * @param value Comma-separated list of additional Kubernetes label keys that will be used in the resource's labels metric (Example: 'namespaces=[k8s-label-1,k8s-label-n,&#46;&#46;&#46;],pods=[app],...'). By default the metric contains only resource name and namespace labels.
     */
    @JvmName("wbyvtnyogptvsyhw")
    public suspend fun metricLabelsAllowlist(`value`: Output<String>) {
        this.metricLabelsAllowlist = value
    }

    /**
     * @param value Comma-separated list of Kubernetes annotation keys that will be used in the resource's labels metric (Example: 'namespaces=[kubernetes&#46;io/team,&#46;&#46;&#46;],pods=[kubernetes&#46;io/team],...'). By default the metric contains only resource name and namespace labels.
     */
    @JvmName("prtxtqgcsponeuwy")
    public suspend fun metricAnnotationsAllowList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricAnnotationsAllowList = mapped
    }

    /**
     * @param value Comma-separated list of additional Kubernetes label keys that will be used in the resource's labels metric (Example: 'namespaces=[k8s-label-1,k8s-label-n,&#46;&#46;&#46;],pods=[app],...'). By default the metric contains only resource name and namespace labels.
     */
    @JvmName("tgqqarhaynlrfhfw")
    public suspend fun metricLabelsAllowlist(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricLabelsAllowlist = mapped
    }

    internal fun build(): ManagedClusterAzureMonitorProfileKubeStateMetricsArgs =
        ManagedClusterAzureMonitorProfileKubeStateMetricsArgs(
            metricAnnotationsAllowList = metricAnnotationsAllowList,
            metricLabelsAllowlist = metricLabelsAllowlist,
        )
}
