@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Desired outbound IP Prefix resources for the cluster load balancer.
 * @property publicIPPrefixes A list of public IP prefix resources.
 */
public data class ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs(
    public val publicIPPrefixes: Output<List<ResourceReferenceArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs.builder()
            .publicIPPrefixes(
                publicIPPrefixes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs].
 */
@PulumiTagMarker
public class ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgsBuilder internal constructor() {
    private var publicIPPrefixes: Output<List<ResourceReferenceArgs>>? = null

    /**
     * @param value A list of public IP prefix resources.
     */
    @JvmName("ytujntapotkemkpb")
    public suspend fun publicIPPrefixes(`value`: Output<List<ResourceReferenceArgs>>) {
        this.publicIPPrefixes = value
    }

    @JvmName("hhniplexeaffixfw")
    public suspend fun publicIPPrefixes(vararg values: Output<ResourceReferenceArgs>) {
        this.publicIPPrefixes = Output.all(values.asList())
    }

    /**
     * @param values A list of public IP prefix resources.
     */
    @JvmName("nyffmdiyltdbkdkk")
    public suspend fun publicIPPrefixes(values: List<Output<ResourceReferenceArgs>>) {
        this.publicIPPrefixes = Output.all(values)
    }

    /**
     * @param value A list of public IP prefix resources.
     */
    @JvmName("oojtjqvkafbeqesk")
    public suspend fun publicIPPrefixes(`value`: List<ResourceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPPrefixes = mapped
    }

    /**
     * @param argument A list of public IP prefix resources.
     */
    @JvmName("rpfkyhqxoqkwbbhf")
    public suspend
    fun publicIPPrefixes(argument: List<suspend ResourceReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.publicIPPrefixes = mapped
    }

    /**
     * @param argument A list of public IP prefix resources.
     */
    @JvmName("pndubfwsufigdjqq")
    public suspend fun publicIPPrefixes(
        vararg
        argument: suspend ResourceReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.publicIPPrefixes = mapped
    }

    /**
     * @param argument A list of public IP prefix resources.
     */
    @JvmName("cxaqjpbnkebbjmks")
    public suspend fun publicIPPrefixes(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.publicIPPrefixes = mapped
    }

    /**
     * @param values A list of public IP prefix resources.
     */
    @JvmName("sdbytveawdhtrtmg")
    public suspend fun publicIPPrefixes(vararg values: ResourceReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPPrefixes = mapped
    }

    internal fun build(): ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs =
        ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs(
            publicIPPrefixes = publicIPPrefixes,
        )
}
