@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileOutboundIPsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Desired outbound IP resources for the cluster load balancer.
 * @property publicIPs A list of public IP resources.
 */
public data class ManagedClusterLoadBalancerProfileOutboundIPsArgs(
    public val publicIPs: Output<List<ResourceReferenceArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileOutboundIPsArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileOutboundIPsArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileOutboundIPsArgs.builder()
            .publicIPs(
                publicIPs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedClusterLoadBalancerProfileOutboundIPsArgs].
 */
@PulumiTagMarker
public class ManagedClusterLoadBalancerProfileOutboundIPsArgsBuilder internal constructor() {
    private var publicIPs: Output<List<ResourceReferenceArgs>>? = null

    /**
     * @param value A list of public IP resources.
     */
    @JvmName("ssvkpghkudmfxmau")
    public suspend fun publicIPs(`value`: Output<List<ResourceReferenceArgs>>) {
        this.publicIPs = value
    }

    @JvmName("vqfmnmmlhgqnmdgc")
    public suspend fun publicIPs(vararg values: Output<ResourceReferenceArgs>) {
        this.publicIPs = Output.all(values.asList())
    }

    /**
     * @param values A list of public IP resources.
     */
    @JvmName("rpthoneumrxdaxha")
    public suspend fun publicIPs(values: List<Output<ResourceReferenceArgs>>) {
        this.publicIPs = Output.all(values)
    }

    /**
     * @param value A list of public IP resources.
     */
    @JvmName("muawtulaoyjguera")
    public suspend fun publicIPs(`value`: List<ResourceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPs = mapped
    }

    /**
     * @param argument A list of public IP resources.
     */
    @JvmName("jspoyvqjoyaqmhfq")
    public suspend fun publicIPs(argument: List<suspend ResourceReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.publicIPs = mapped
    }

    /**
     * @param argument A list of public IP resources.
     */
    @JvmName("eokhjdfegopfvwvv")
    public suspend fun publicIPs(vararg argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.publicIPs = mapped
    }

    /**
     * @param argument A list of public IP resources.
     */
    @JvmName("yfcosxatwettdrme")
    public suspend fun publicIPs(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.publicIPs = mapped
    }

    /**
     * @param values A list of public IP resources.
     */
    @JvmName("mcehsojnewtilxjx")
    public suspend fun publicIPs(vararg values: ResourceReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPs = mapped
    }

    internal fun build(): ManagedClusterLoadBalancerProfileOutboundIPsArgs =
        ManagedClusterLoadBalancerProfileOutboundIPsArgs(
            publicIPs = publicIPs,
        )
}
