@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterNATGatewayProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Profile of the managed cluster NAT gateway.
 * @property effectiveOutboundIPs The effective outbound IP resources of the cluster NAT gateway.
 * @property idleTimeoutInMinutes Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value is 4 minutes.
 * @property managedOutboundIPProfile Profile of the managed outbound IP resources of the cluster NAT gateway.
 */
public data class ManagedClusterNATGatewayProfileArgs(
    public val effectiveOutboundIPs: Output<List<ResourceReferenceArgs>>? = null,
    public val idleTimeoutInMinutes: Output<Int>? = null,
    public val managedOutboundIPProfile: Output<ManagedClusterManagedOutboundIPProfileArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterNATGatewayProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterNATGatewayProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterNATGatewayProfileArgs.builder()
            .effectiveOutboundIPs(
                effectiveOutboundIPs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .idleTimeoutInMinutes(idleTimeoutInMinutes?.applyValue({ args0 -> args0 }))
            .managedOutboundIPProfile(
                managedOutboundIPProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedClusterNATGatewayProfileArgs].
 */
@PulumiTagMarker
public class ManagedClusterNATGatewayProfileArgsBuilder internal constructor() {
    private var effectiveOutboundIPs: Output<List<ResourceReferenceArgs>>? = null

    private var idleTimeoutInMinutes: Output<Int>? = null

    private var managedOutboundIPProfile: Output<ManagedClusterManagedOutboundIPProfileArgs>? = null

    /**
     * @param value The effective outbound IP resources of the cluster NAT gateway.
     */
    @JvmName("ashgqpwasnfrfixv")
    public suspend fun effectiveOutboundIPs(`value`: Output<List<ResourceReferenceArgs>>) {
        this.effectiveOutboundIPs = value
    }

    @JvmName("ukrvehwkchqwoowq")
    public suspend fun effectiveOutboundIPs(vararg values: Output<ResourceReferenceArgs>) {
        this.effectiveOutboundIPs = Output.all(values.asList())
    }

    /**
     * @param values The effective outbound IP resources of the cluster NAT gateway.
     */
    @JvmName("adqajjlpgxysrrtm")
    public suspend fun effectiveOutboundIPs(values: List<Output<ResourceReferenceArgs>>) {
        this.effectiveOutboundIPs = Output.all(values)
    }

    /**
     * @param value Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value is 4 minutes.
     */
    @JvmName("nwxvtkqdnyjcxgji")
    public suspend fun idleTimeoutInMinutes(`value`: Output<Int>) {
        this.idleTimeoutInMinutes = value
    }

    /**
     * @param value Profile of the managed outbound IP resources of the cluster NAT gateway.
     */
    @JvmName("avxohktsrejvymsg")
    public suspend
    fun managedOutboundIPProfile(`value`: Output<ManagedClusterManagedOutboundIPProfileArgs>) {
        this.managedOutboundIPProfile = value
    }

    /**
     * @param value The effective outbound IP resources of the cluster NAT gateway.
     */
    @JvmName("shcpvtfiahkvdwaa")
    public suspend fun effectiveOutboundIPs(`value`: List<ResourceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveOutboundIPs = mapped
    }

    /**
     * @param argument The effective outbound IP resources of the cluster NAT gateway.
     */
    @JvmName("ejbsnhpfgdptrljf")
    public suspend
    fun effectiveOutboundIPs(argument: List<suspend ResourceReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.effectiveOutboundIPs = mapped
    }

    /**
     * @param argument The effective outbound IP resources of the cluster NAT gateway.
     */
    @JvmName("nwynqqqdfuwbgwiq")
    public suspend fun effectiveOutboundIPs(
        vararg
        argument: suspend ResourceReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.effectiveOutboundIPs = mapped
    }

    /**
     * @param argument The effective outbound IP resources of the cluster NAT gateway.
     */
    @JvmName("erbdrkjailygjvex")
    public suspend
    fun effectiveOutboundIPs(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.effectiveOutboundIPs = mapped
    }

    /**
     * @param values The effective outbound IP resources of the cluster NAT gateway.
     */
    @JvmName("wnssfxvaoqnjkmna")
    public suspend fun effectiveOutboundIPs(vararg values: ResourceReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.effectiveOutboundIPs = mapped
    }

    /**
     * @param value Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value is 4 minutes.
     */
    @JvmName("gleuxdeoxnmafgkt")
    public suspend fun idleTimeoutInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeoutInMinutes = mapped
    }

    /**
     * @param value Profile of the managed outbound IP resources of the cluster NAT gateway.
     */
    @JvmName("ljnqkfdubupkfpub")
    public suspend
    fun managedOutboundIPProfile(`value`: ManagedClusterManagedOutboundIPProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedOutboundIPProfile = mapped
    }

    /**
     * @param argument Profile of the managed outbound IP resources of the cluster NAT gateway.
     */
    @JvmName("reucttdnfmeqbjbi")
    public suspend
    fun managedOutboundIPProfile(argument: suspend ManagedClusterManagedOutboundIPProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterManagedOutboundIPProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.managedOutboundIPProfile = mapped
    }

    internal fun build(): ManagedClusterNATGatewayProfileArgs = ManagedClusterNATGatewayProfileArgs(
        effectiveOutboundIPs = effectiveOutboundIPs,
        idleTimeoutInMinutes = idleTimeoutInMinutes,
        managedOutboundIPProfile = managedOutboundIPProfile,
    )
}
