@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPodIdentityExceptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * See [disable AAD Pod Identity for a specific Pod/Application](https://azure.github.io/aad-pod-identity/docs/configure/application_exception/) for more details.
 * @property name The name of the pod identity exception.
 * @property namespace The namespace of the pod identity exception.
 * @property podLabels The pod labels to match.
 */
public data class ManagedClusterPodIdentityExceptionArgs(
    public val name: Output<String>,
    public val namespace: Output<String>,
    public val podLabels: Output<Map<String, String>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterPodIdentityExceptionArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterPodIdentityExceptionArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterPodIdentityExceptionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .namespace(namespace.applyValue({ args0 -> args0 }))
            .podLabels(
                podLabels.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ManagedClusterPodIdentityExceptionArgs].
 */
@PulumiTagMarker
public class ManagedClusterPodIdentityExceptionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var namespace: Output<String>? = null

    private var podLabels: Output<Map<String, String>>? = null

    /**
     * @param value The name of the pod identity exception.
     */
    @JvmName("bidmchobpqbebbeu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The namespace of the pod identity exception.
     */
    @JvmName("ifhigjqvfjpthage")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value The pod labels to match.
     */
    @JvmName("yoraanqlvaxahgsx")
    public suspend fun podLabels(`value`: Output<Map<String, String>>) {
        this.podLabels = value
    }

    /**
     * @param value The name of the pod identity exception.
     */
    @JvmName("ybrobskgplbjktmn")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The namespace of the pod identity exception.
     */
    @JvmName("ixdipfihdjeahmuf")
    public suspend fun namespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value The pod labels to match.
     */
    @JvmName("escamlpgeideebiy")
    public suspend fun podLabels(`value`: Map<String, String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.podLabels = mapped
    }

    /**
     * @param values The pod labels to match.
     */
    @JvmName("iktwixnwuionqjrx")
    public fun podLabels(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.podLabels = mapped
    }

    internal fun build(): ManagedClusterPodIdentityExceptionArgs =
        ManagedClusterPodIdentityExceptionArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            namespace = namespace ?: throw PulumiNullFieldException("namespace"),
            podLabels = podLabels ?: throw PulumiNullFieldException("podLabels"),
        )
}
