@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Security profile for the container service cluster.
 * @property azureKeyVaultKms Azure Key Vault [key management service](https://kubernetes.io/docs/tasks/administer-cluster/kms-provider/) settings for the security profile.
 * @property defender Microsoft Defender settings for the security profile.
 * @property imageCleaner Image Cleaner settings for the security profile.
 * @property workloadIdentity Workload identity settings for the security profile. Workload identity enables Kubernetes applications to access Azure cloud resources securely with Azure AD. See https://aka.ms/aks/wi for more details.
 */
public data class ManagedClusterSecurityProfileArgs(
    public val azureKeyVaultKms: Output<AzureKeyVaultKmsArgs>? = null,
    public val defender: Output<ManagedClusterSecurityProfileDefenderArgs>? = null,
    public val imageCleaner: Output<ManagedClusterSecurityProfileImageCleanerArgs>? = null,
    public val workloadIdentity: Output<ManagedClusterSecurityProfileWorkloadIdentityArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileArgs.builder()
            .azureKeyVaultKms(azureKeyVaultKms?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .defender(defender?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .imageCleaner(imageCleaner?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .workloadIdentity(
                workloadIdentity?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedClusterSecurityProfileArgs].
 */
@PulumiTagMarker
public class ManagedClusterSecurityProfileArgsBuilder internal constructor() {
    private var azureKeyVaultKms: Output<AzureKeyVaultKmsArgs>? = null

    private var defender: Output<ManagedClusterSecurityProfileDefenderArgs>? = null

    private var imageCleaner: Output<ManagedClusterSecurityProfileImageCleanerArgs>? = null

    private var workloadIdentity: Output<ManagedClusterSecurityProfileWorkloadIdentityArgs>? = null

    /**
     * @param value Azure Key Vault [key management service](https://kubernetes.io/docs/tasks/administer-cluster/kms-provider/) settings for the security profile.
     */
    @JvmName("ugcojnlsaocofbku")
    public suspend fun azureKeyVaultKms(`value`: Output<AzureKeyVaultKmsArgs>) {
        this.azureKeyVaultKms = value
    }

    /**
     * @param value Microsoft Defender settings for the security profile.
     */
    @JvmName("pxydvyighrbienut")
    public suspend fun defender(`value`: Output<ManagedClusterSecurityProfileDefenderArgs>) {
        this.defender = value
    }

    /**
     * @param value Image Cleaner settings for the security profile.
     */
    @JvmName("oucsjomjsxklcdaj")
    public suspend fun imageCleaner(`value`: Output<ManagedClusterSecurityProfileImageCleanerArgs>) {
        this.imageCleaner = value
    }

    /**
     * @param value Workload identity settings for the security profile. Workload identity enables Kubernetes applications to access Azure cloud resources securely with Azure AD. See https://aka.ms/aks/wi for more details.
     */
    @JvmName("vqkwxbqtiuivepab")
    public suspend
    fun workloadIdentity(`value`: Output<ManagedClusterSecurityProfileWorkloadIdentityArgs>) {
        this.workloadIdentity = value
    }

    /**
     * @param value Azure Key Vault [key management service](https://kubernetes.io/docs/tasks/administer-cluster/kms-provider/) settings for the security profile.
     */
    @JvmName("eolurpurocgdcluq")
    public suspend fun azureKeyVaultKms(`value`: AzureKeyVaultKmsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureKeyVaultKms = mapped
    }

    /**
     * @param argument Azure Key Vault [key management service](https://kubernetes.io/docs/tasks/administer-cluster/kms-provider/) settings for the security profile.
     */
    @JvmName("jptvnpkyoyyfykpv")
    public suspend fun azureKeyVaultKms(argument: suspend AzureKeyVaultKmsArgsBuilder.() -> Unit) {
        val toBeMapped = AzureKeyVaultKmsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureKeyVaultKms = mapped
    }

    /**
     * @param value Microsoft Defender settings for the security profile.
     */
    @JvmName("wrtgnhbwmojaqquq")
    public suspend fun defender(`value`: ManagedClusterSecurityProfileDefenderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defender = mapped
    }

    /**
     * @param argument Microsoft Defender settings for the security profile.
     */
    @JvmName("lmpmifkoioojuafu")
    public suspend
    fun defender(argument: suspend ManagedClusterSecurityProfileDefenderArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterSecurityProfileDefenderArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.defender = mapped
    }

    /**
     * @param value Image Cleaner settings for the security profile.
     */
    @JvmName("fasxshwbrycsqeqs")
    public suspend fun imageCleaner(`value`: ManagedClusterSecurityProfileImageCleanerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageCleaner = mapped
    }

    /**
     * @param argument Image Cleaner settings for the security profile.
     */
    @JvmName("oniegctnbglymwmj")
    public suspend
    fun imageCleaner(argument: suspend ManagedClusterSecurityProfileImageCleanerArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterSecurityProfileImageCleanerArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.imageCleaner = mapped
    }

    /**
     * @param value Workload identity settings for the security profile. Workload identity enables Kubernetes applications to access Azure cloud resources securely with Azure AD. See https://aka.ms/aks/wi for more details.
     */
    @JvmName("xcoeejkccqxxpixw")
    public suspend fun workloadIdentity(`value`: ManagedClusterSecurityProfileWorkloadIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadIdentity = mapped
    }

    /**
     * @param argument Workload identity settings for the security profile. Workload identity enables Kubernetes applications to access Azure cloud resources securely with Azure AD. See https://aka.ms/aks/wi for more details.
     */
    @JvmName("ivyrwgvuhpamlqct")
    public suspend
    fun workloadIdentity(argument: suspend ManagedClusterSecurityProfileWorkloadIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterSecurityProfileWorkloadIdentityArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.workloadIdentity = mapped
    }

    internal fun build(): ManagedClusterSecurityProfileArgs = ManagedClusterSecurityProfileArgs(
        azureKeyVaultKms = azureKeyVaultKms,
        defender = defender,
        imageCleaner = imageCleaner,
        workloadIdentity = workloadIdentity,
    )
}
