@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterStorageProfileBlobCSIDriverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * AzureBlob CSI Driver settings for the storage profile.
 * @property enabled Whether to enable AzureBlob CSI Driver. The default value is false.
 */
public data class ManagedClusterStorageProfileBlobCSIDriverArgs(
    public val enabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterStorageProfileBlobCSIDriverArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterStorageProfileBlobCSIDriverArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterStorageProfileBlobCSIDriverArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedClusterStorageProfileBlobCSIDriverArgs].
 */
@PulumiTagMarker
public class ManagedClusterStorageProfileBlobCSIDriverArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Whether to enable AzureBlob CSI Driver. The default value is false.
     */
    @JvmName("inkapsqggcmxthbf")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Whether to enable AzureBlob CSI Driver. The default value is false.
     */
    @JvmName("uocjpvsxoxysdacp")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): ManagedClusterStorageProfileBlobCSIDriverArgs =
        ManagedClusterStorageProfileBlobCSIDriverArgs(
            enabled = enabled,
        )
}
