@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterStorageProfileDiskCSIDriverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * AzureDisk CSI Driver settings for the storage profile.
 * @property enabled Whether to enable AzureDisk CSI Driver. The default value is true.
 */
public data class ManagedClusterStorageProfileDiskCSIDriverArgs(
    public val enabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterStorageProfileDiskCSIDriverArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterStorageProfileDiskCSIDriverArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterStorageProfileDiskCSIDriverArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedClusterStorageProfileDiskCSIDriverArgs].
 */
@PulumiTagMarker
public class ManagedClusterStorageProfileDiskCSIDriverArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Whether to enable AzureDisk CSI Driver. The default value is true.
     */
    @JvmName("ntjkeourfehxfynj")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Whether to enable AzureDisk CSI Driver. The default value is true.
     */
    @JvmName("rbmtxddcexcanlei")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): ManagedClusterStorageProfileDiskCSIDriverArgs =
        ManagedClusterStorageProfileDiskCSIDriverArgs(
            enabled = enabled,
        )
}
