@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.OpenShiftAPIPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines further properties on the API.
 * @property privateApiServer Specifies if API server is public or private.
 */
public data class OpenShiftAPIPropertiesArgs(
    public val privateApiServer: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.OpenShiftAPIPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.OpenShiftAPIPropertiesArgs =
        com.pulumi.azurenative.containerservice.inputs.OpenShiftAPIPropertiesArgs.builder()
            .privateApiServer(privateApiServer?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OpenShiftAPIPropertiesArgs].
 */
@PulumiTagMarker
public class OpenShiftAPIPropertiesArgsBuilder internal constructor() {
    private var privateApiServer: Output<Boolean>? = null

    /**
     * @param value Specifies if API server is public or private.
     */
    @JvmName("kmrmffnlqowuxkho")
    public suspend fun privateApiServer(`value`: Output<Boolean>) {
        this.privateApiServer = value
    }

    /**
     * @param value Specifies if API server is public or private.
     */
    @JvmName("kfffubwdwptsbjal")
    public suspend fun privateApiServer(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateApiServer = mapped
    }

    internal fun build(): OpenShiftAPIPropertiesArgs = OpenShiftAPIPropertiesArgs(
        privateApiServer = privateApiServer,
    )
}
