@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterAuthProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines all possible authentication profiles for the OpenShift cluster.
 * @property identityProviders Type of authentication profile to use.
 */
public data class OpenShiftManagedClusterAuthProfileArgs(
    public val identityProviders: Output<List<OpenShiftManagedClusterIdentityProviderArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterAuthProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterAuthProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterAuthProfileArgs.builder()
            .identityProviders(
                identityProviders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [OpenShiftManagedClusterAuthProfileArgs].
 */
@PulumiTagMarker
public class OpenShiftManagedClusterAuthProfileArgsBuilder internal constructor() {
    private var identityProviders: Output<List<OpenShiftManagedClusterIdentityProviderArgs>>? = null

    /**
     * @param value Type of authentication profile to use.
     */
    @JvmName("gwbrdxnstaaxhuwv")
    public suspend
    fun identityProviders(`value`: Output<List<OpenShiftManagedClusterIdentityProviderArgs>>) {
        this.identityProviders = value
    }

    @JvmName("dixhonnptmnklgwv")
    public suspend fun identityProviders(
        vararg
        values: Output<OpenShiftManagedClusterIdentityProviderArgs>,
    ) {
        this.identityProviders = Output.all(values.asList())
    }

    /**
     * @param values Type of authentication profile to use.
     */
    @JvmName("wxsnqsxwvvbiycxo")
    public suspend
    fun identityProviders(values: List<Output<OpenShiftManagedClusterIdentityProviderArgs>>) {
        this.identityProviders = Output.all(values)
    }

    /**
     * @param value Type of authentication profile to use.
     */
    @JvmName("ucwtcxmntoopafvx")
    public suspend
    fun identityProviders(`value`: List<OpenShiftManagedClusterIdentityProviderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityProviders = mapped
    }

    /**
     * @param argument Type of authentication profile to use.
     */
    @JvmName("bvtkkxfywjpvxpri")
    public suspend
    fun identityProviders(argument: List<suspend OpenShiftManagedClusterIdentityProviderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OpenShiftManagedClusterIdentityProviderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.identityProviders = mapped
    }

    /**
     * @param argument Type of authentication profile to use.
     */
    @JvmName("jvvsddyahgyiwtto")
    public suspend fun identityProviders(
        vararg
        argument: suspend OpenShiftManagedClusterIdentityProviderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            OpenShiftManagedClusterIdentityProviderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.identityProviders = mapped
    }

    /**
     * @param argument Type of authentication profile to use.
     */
    @JvmName("gxxdiccumtbksvpn")
    public suspend
    fun identityProviders(argument: suspend OpenShiftManagedClusterIdentityProviderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            OpenShiftManagedClusterIdentityProviderArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.identityProviders = mapped
    }

    /**
     * @param values Type of authentication profile to use.
     */
    @JvmName("atwvrfmtpvguuclt")
    public suspend fun identityProviders(vararg values: OpenShiftManagedClusterIdentityProviderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identityProviders = mapped
    }

    internal fun build(): OpenShiftManagedClusterAuthProfileArgs =
        OpenShiftManagedClusterAuthProfileArgs(
            identityProviders = identityProviders,
        )
}
