@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterMonitorProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the configuration for Log Analytics integration.
 * @property enabled If the Log analytics integration should be turned on or off
 * @property workspaceResourceID Azure Resource Manager Resource ID for the Log Analytics workspace to integrate with.
 */
public data class OpenShiftManagedClusterMonitorProfileArgs(
    public val enabled: Output<Boolean>? = null,
    public val workspaceResourceID: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterMonitorProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterMonitorProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterMonitorProfileArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .workspaceResourceID(workspaceResourceID?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OpenShiftManagedClusterMonitorProfileArgs].
 */
@PulumiTagMarker
public class OpenShiftManagedClusterMonitorProfileArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var workspaceResourceID: Output<String>? = null

    /**
     * @param value If the Log analytics integration should be turned on or off
     */
    @JvmName("jejvwjdfvwowrlba")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Azure Resource Manager Resource ID for the Log Analytics workspace to integrate with.
     */
    @JvmName("gqfoxihmewggylgu")
    public suspend fun workspaceResourceID(`value`: Output<String>) {
        this.workspaceResourceID = value
    }

    /**
     * @param value If the Log analytics integration should be turned on or off
     */
    @JvmName("evhahvkcwryrewmy")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Azure Resource Manager Resource ID for the Log Analytics workspace to integrate with.
     */
    @JvmName("bujssgvsfuerlyam")
    public suspend fun workspaceResourceID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceResourceID = mapped
    }

    internal fun build(): OpenShiftManagedClusterMonitorProfileArgs =
        OpenShiftManagedClusterMonitorProfileArgs(
            enabled = enabled,
            workspaceResourceID = workspaceResourceID,
        )
}
