@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.UpdateGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A group to be updated.
 * @property name Name of the group.
 * It must match a group name of an existing fleet member.
 */
public data class UpdateGroupArgs(
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.UpdateGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.UpdateGroupArgs =
        com.pulumi.azurenative.containerservice.inputs.UpdateGroupArgs.builder()
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UpdateGroupArgs].
 */
@PulumiTagMarker
public class UpdateGroupArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Name of the group.
     * It must match a group name of an existing fleet member.
     */
    @JvmName("mxdabwnhlqiomjpy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the group.
     * It must match a group name of an existing fleet member.
     */
    @JvmName("amvuenvyspmjilvd")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): UpdateGroupArgs = UpdateGroupArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
