@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.UserAssignedIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Details about a user assigned identity.
 * @property clientId The client ID of the user assigned identity.
 * @property objectId The object ID of the user assigned identity.
 * @property resourceId The resource ID of the user assigned identity.
 */
public data class UserAssignedIdentityArgs(
    public val clientId: Output<String>? = null,
    public val objectId: Output<String>? = null,
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.UserAssignedIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.UserAssignedIdentityArgs =
        com.pulumi.azurenative.containerservice.inputs.UserAssignedIdentityArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .objectId(objectId?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserAssignedIdentityArgs].
 */
@PulumiTagMarker
public class UserAssignedIdentityArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var objectId: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value The client ID of the user assigned identity.
     */
    @JvmName("vjqodhxefgrtvagx")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The object ID of the user assigned identity.
     */
    @JvmName("rqmpfvyfgbqnxkig")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value The resource ID of the user assigned identity.
     */
    @JvmName("uhrufhedhqlwtggu")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The client ID of the user assigned identity.
     */
    @JvmName("vlemqntsdfwhootn")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The object ID of the user assigned identity.
     */
    @JvmName("phcfpdedisdmywhf")
    public suspend fun objectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    /**
     * @param value The resource ID of the user assigned identity.
     */
    @JvmName("tsvpvrmnneacgjfu")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): UserAssignedIdentityArgs = UserAssignedIdentityArgs(
        clientId = clientId,
        objectId = objectId,
        resourceId = resourceId,
    )
}
