@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Settings for upgrading an agentpool
 * @property maxSurge This can either be set to an integer (e.g. '5') or a percentage (e.g. '50%'). If a percentage is specified, it is the percentage of the total agent pool size at the time of the upgrade. For percentages, fractional nodes are rounded up. If not specified, the default is 1. For more information, including best practices, see: https://docs.microsoft.com/azure/aks/upgrade-cluster#customize-node-surge-upgrade
 */
public data class AgentPoolUpgradeSettingsResponse(
    public val maxSurge: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.AgentPoolUpgradeSettingsResponse):
            AgentPoolUpgradeSettingsResponse = AgentPoolUpgradeSettingsResponse(
            maxSurge = javaType.maxSurge().map({ args0 -> args0 }).orElse(null),
        )
    }
}
