@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Profile for Linux VMs in the container service cluster.
 * @property adminUsername The administrator username to use for Linux VMs.
 * @property ssh The SSH configuration for Linux-based VMs running on Azure.
 */
public data class ContainerServiceLinuxProfileResponse(
    public val adminUsername: String,
    public val ssh: ContainerServiceSshConfigurationResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ContainerServiceLinuxProfileResponse):
            ContainerServiceLinuxProfileResponse = ContainerServiceLinuxProfileResponse(
            adminUsername = javaType.adminUsername(),
            ssh = javaType.ssh().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.ContainerServiceSshConfigurationResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
