@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * SSH configuration for Linux-based VMs running on Azure.
 * @property publicKeys The list of SSH public keys used to authenticate with Linux-based VMs. A maximum of 1 key may be specified.
 */
public data class ContainerServiceSshConfigurationResponse(
    public val publicKeys: List<ContainerServiceSshPublicKeyResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ContainerServiceSshConfigurationResponse):
            ContainerServiceSshConfigurationResponse = ContainerServiceSshConfigurationResponse(
            publicKeys = javaType.publicKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ContainerServiceSshPublicKeyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
