@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A managed cluster snapshot resource.
 * @property creationData CreationData to be used to specify the source resource ID to create this snapshot.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property managedClusterPropertiesReadOnly What the properties will be showed when getting managed cluster snapshot. Those properties are read-only.
 * @property name The name of the resource
 * @property snapshotType The type of a snapshot. The default is NodePool.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetManagedClusterSnapshotResult(
    public val creationData: CreationDataResponse? = null,
    public val id: String,
    public val location: String,
    public val managedClusterPropertiesReadOnly: ManagedClusterPropertiesForSnapshotResponse,
    public val name: String,
    public val snapshotType: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.GetManagedClusterSnapshotResult):
            GetManagedClusterSnapshotResult = GetManagedClusterSnapshotResult(
            creationData = javaType.creationData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.CreationDataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            managedClusterPropertiesReadOnly = javaType.managedClusterPropertiesReadOnly().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterPropertiesForSnapshotResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            snapshotType = javaType.snapshotType().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
