@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * OpenShift Managed cluster.
 * @property agentPoolProfiles Configuration of OpenShift cluster VMs.
 * @property authProfile Configures OpenShift authentication.
 * @property clusterVersion Version of OpenShift specified when creating the cluster.
 * @property fqdn Service generated FQDN for OpenShift API server loadbalancer internal hostname.
 * @property id Resource Id
 * @property location Resource location
 * @property masterPoolProfile Configuration for OpenShift master VMs.
 * @property monitorProfile Configures Log Analytics integration.
 * @property name Resource name
 * @property networkProfile Configuration for OpenShift networking.
 * @property openShiftVersion Version of OpenShift specified when creating the cluster.
 * @property plan Define the resource plan as required by ARM for billing purposes
 * @property provisioningState The current deployment or provisioning state, which only appears in the response.
 * @property publicHostname Service generated FQDN or private IP for OpenShift API server.
 * @property refreshCluster Allows node rotation
 * @property routerProfiles Configuration for OpenShift router(s).
 * @property tags Resource tags
 * @property type Resource type
 */
public data class GetOpenShiftManagedClusterResult(
    public val agentPoolProfiles: List<OpenShiftManagedClusterAgentPoolProfileResponse>? = null,
    public val authProfile: OpenShiftManagedClusterAuthProfileResponse? = null,
    public val clusterVersion: String,
    public val fqdn: String,
    public val id: String,
    public val location: String,
    public val masterPoolProfile: OpenShiftManagedClusterMasterPoolProfileResponse? = null,
    public val monitorProfile: OpenShiftManagedClusterMonitorProfileResponse? = null,
    public val name: String,
    public val networkProfile: NetworkProfileResponse? = null,
    public val openShiftVersion: String,
    public val plan: PurchasePlanResponse? = null,
    public val provisioningState: String,
    public val publicHostname: String,
    public val refreshCluster: Boolean? = null,
    public val routerProfiles: List<OpenShiftRouterProfileResponse>? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.GetOpenShiftManagedClusterResult):
            GetOpenShiftManagedClusterResult = GetOpenShiftManagedClusterResult(
            agentPoolProfiles = javaType.agentPoolProfiles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.OpenShiftManagedClusterAgentPoolProfileResponse.Companion.toKotlin(args0)
                })
            }),
            authProfile = javaType.authProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.OpenShiftManagedClusterAuthProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            clusterVersion = javaType.clusterVersion(),
            fqdn = javaType.fqdn(),
            id = javaType.id(),
            location = javaType.location(),
            masterPoolProfile = javaType.masterPoolProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.OpenShiftManagedClusterMasterPoolProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            monitorProfile = javaType.monitorProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.OpenShiftManagedClusterMonitorProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            networkProfile = javaType.networkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            openShiftVersion = javaType.openShiftVersion(),
            plan = javaType.plan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.PurchasePlanResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            publicHostname = javaType.publicHostname(),
            refreshCluster = javaType.refreshCluster().map({ args0 -> args0 }).orElse(null),
            routerProfiles = javaType.routerProfiles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.OpenShiftRouterProfileResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
